function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/baja/Pen
 */
define(['baja!', 'lex!gx'], function (baja, lexs) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
    gxLex = _lexs[0];

  /**
   * A javascript based implementation of gx:Pen
   *
   * @class
   * @alias module:nmodule/gx/rc/baja/Pen
   * @extends baja.Simple
   */
  var Pen = /*#__PURE__*/function (_baja$Simple) {
    /**
     * Constructs a Pen with given width, cap, join style and dash pattern. in the below mentioned cases
     *
     * @param {number} width - The width of the pen. defaults to one. Will throw an error when it is not a
     *      positive number (Not a number and positive infinite values are accepted.)
     * @param {number} cap - The cap style of the pen. Will throw an error when it is not one of
     *      {Pen.CAP_BUTT, Pen.CAP_SQUARE, Pen.CAP_ROUND}
     * @param {number} join - The join style of the pen. Will throw an error when it is not one of
     *      {Pen.JOIN_MITER, Pen.JOIN_ROUND, Pen.JOIN_BEVEL}
     * @param {Array.<number>|null} dash - The dash pattern of the pen. Will throw an error when it
     *      is neither null nor a number array
     */
    function Pen(width, cap, join, dash) {
      var _this;
      _classCallCheck(this, Pen);
      _this = _callSuper(this, Pen);
      // Width must be a number
      if (!isNumber(width) || width < 0) {
        throw new Error(gxLex.get('pen.width.error', width));
      }
      // Pen Cap must be an integer in {101, 102, 103}
      if (!isValidCap(cap)) {
        throw new Error(gxLex.get('pen.cap.error', cap));
      }
      // Pen Join must be an integer in {201, 202, 203}
      if (!isValidJoin(join)) {
        throw new Error(gxLex.get('pen.join.error', join));
      }
      // Dash value must be a number array
      mustBeNullOrNumberArray(dash);
      _this.$width = width;
      _this.$cap = cap;
      _this.$join = join;
      _this.$dash = dash || Pen.noDash;
      return _this;
    }

    /**
     * Make a pen with the passed width, cap, join and dash pattern.
     *
     * @example
     * // creates a pen with specified width, cap, join and dash pattern
     * let pen = Pen.make(34.7, Pen.CAP_SQUARE, Pen.JOIN_ROUND, [12, 13.4]);
     *
     * @example
     * // creates a pen with specified width and dash pattern. In this case the cap and join will be defaulted to Pen.CAP_BUTT and Pen.JOIN_MITER respectively.
     * let pen = Pen.make(34.7, [12, 13.4]);
     *
     * @example
     * // creates a pen with specified width. In this case the cap and join will be defaulted to Pen.CAP_BUTT and Pen.JOIN_MITER respectively and the dash pattern will be empty.
     * let pen = Pen.make(34.7);
     *
     * @param {...*} pen
     * @returns {module:nmodule/gx/rc/baja/Pen}
     */
    _inherits(Pen, _baja$Simple);
    return _createClass(Pen, [{
      key: "make",
      value:
      /**
       * Make a pen with the passed width, cap, join and dash pattern.
       *
       * @param {...*} pen
       * @returns {module:nmodule/gx/rc/baja/Pen}
       */
      function make() {
        return Pen.make.apply(Pen, arguments);
      }

      /**
       * Get the width of the Pen
       *
       * @returns {number}
       */
    }, {
      key: "getWidth",
      value: function getWidth() {
        return this.$width;
      }

      /**
       * Get the cap type of the pen
       *
       * @returns {number}
       */
    }, {
      key: "getCap",
      value: function getCap() {
        return this.$cap;
      }

      /**
       * Get the join type of the pen
       *
       * @returns {number}
       */
    }, {
      key: "getJoin",
      value: function getJoin() {
        return this.$join;
      }

      /**
       * Get the dash width array's safe copy
       *
       * @returns {Array<number>}
       */
    }, {
      key: "getDash",
      value: function getDash() {
        return this.$dash.slice();
      }

      /**
       * Encodes the Pen to the "Width Cap Join dash(...)" format.
       *
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        var capString = '',
          joinString = '',
          dashString = '',
          width = this.$width.encodeToString();
        if (this.$cap !== Pen.CAP_BUTT) {
          capString = " ".concat(this.$getCapString());
        }
        if (this.$join !== Pen.JOIN_MITER) {
          joinString = " ".concat(this.$getJoinString());
        }
        if (this.$dash && this.$dash.length > 0) {
          dashString = this.$dash.map(function (val) {
            return val.encodeToString();
          }).join(',');
          dashString = " dash(".concat(dashString, ")");
        }
        return "".concat(width).concat(capString).concat(joinString).concat(dashString);
      }

      /**
       * Converts a string value into a Pen tuple. Throws an error if the string is not in the valid format.
       *
       * @param {string} string
       * @returns {module:nmodule/gx/rc/baja/Pen}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(string) {
        return this.$parsePen(string);
      }

      /**
       * Apply this pen to an svg element
       * 
       * @param {Element} svgEl 
       */
    }, {
      key: "applyToSvgElement",
      value: function applyToSvgElement(svgEl) {
        var _this2 = this;
        svgEl.setAttribute('stroke-width', this.getWidth());
        svgEl.setAttribute('stroke-dasharray', this.getDash().map(function (d) {
          return d * _this2.getWidth();
        }).join(' '));
        svgEl.setAttribute('stroke-linejoin', this.$getJoinString().replace(/join/, ''));
        svgEl.setAttribute('stroke-linecap', this.$getCapString().replace(/cap/, ''));
      }

      /**
       * Parse the encoded string to a pen
       *
       * @private
       * @param {string} string
       * @returns {module:nmodule/gx/rc/baja/Pen}
       */
    }, {
      key: "$parsePen",
      value: function $parsePen(string) {
        var width = 1,
          cap = Pen.CAP_BUTT,
          join = Pen.JOIN_MITER,
          dash = Pen.noDash;
        var params = string.split(' ');
        if (params.length >= 1) {
          // width = baja.Double.DEFAULT.decodeFromString(params[0]);
          width = this.$decodeWidthString(params[0]);
          for (var index = 1; index < params.length; index++) {
            var _this$$getPenStylePar = this.$getPenStyleParams(params[index]),
              _this$$getPenStylePar2 = _slicedToArray(_this$$getPenStylePar, 3),
              capTemp = _this$$getPenStylePar2[0],
              joinTemp = _this$$getPenStylePar2[1],
              dashTemp = _this$$getPenStylePar2[2];
            if (capTemp === null && joinTemp === null && dashTemp === null) {
              throw new Error(gxLex.get('pen.decode.error', params[index]));
            }
            cap = capTemp || cap;
            join = joinTemp || join;
            dash = dashTemp || dash;
          }
        }
        return Pen.make(width, cap, join, dash);
      }

      /**
       * Get the style parameters for the given string based on the aspect of style parameter it depends on.
       * @param {string} styleParam
       * @returns {Array.<*|null>}
       */
    }, {
      key: "$getPenStyleParams",
      value: function $getPenStyleParams(styleParam) {
        var cap = null,
          join = null,
          dash = null;
        if (this.$isCapString(styleParam)) {
          cap = this.$decodeCapString(styleParam);
        } else if (this.$isJoinString(styleParam)) {
          join = this.$decodeJoinString(styleParam);
        } else if (this.$isDashString(styleParam)) {
          dash = this.$decodeDashString(styleParam);
        }
        return [cap, join, dash];
      }

      /**
       * Get the string representation for pen cap
       *
       * @private
       * @returns {string}
       */
    }, {
      key: "$getCapString",
      value: function $getCapString() {
        switch (this.$cap) {
          case Pen.CAP_BUTT:
            return "capButt";
          case Pen.CAP_SQUARE:
            return "capSquare";
          case Pen.CAP_ROUND:
            return "capRound";
          default:
            throw new Error(gxLex.get('pen.cap.error', this.$cap));
        }
      }

      /**
       * Get the string representation for pen join
       *
       * @private
       * @returns {string}
       */
    }, {
      key: "$getJoinString",
      value: function $getJoinString() {
        switch (this.$join) {
          case Pen.JOIN_MITER:
            return "joinMiter";
          case Pen.JOIN_ROUND:
            return "joinRound";
          case Pen.JOIN_BEVEL:
            return "joinBevel";
          default:
            throw new Error(gxLex.get('pen.join.error', this.$join));
        }
      }

      /**
       * Returns the integer value for the width string. It defaults special numeric values (nan/+inf/-inf) to 1
       *
       * @private
       * @param {string} string
       * @returns {number}
       */
    }, {
      key: "$decodeWidthString",
      value: function $decodeWidthString(string) {
        var width = 1;
        var isSpecialNumber = string === "nan" || string === "+inf" || string === "-inf";
        if (!isSpecialNumber) {
          width = baja.Double.DEFAULT.decodeFromString(string);
        }
        return width;
      }

      /**
       * Get the integer representation for pen cap
       *
       * @private
       * @param {string} string
       * @returns {number}
       */
    }, {
      key: "$decodeCapString",
      value: function $decodeCapString(string) {
        if (string === "capButt") {
          return Pen.CAP_BUTT;
        } else if (string === "capSquare") {
          return Pen.CAP_SQUARE;
        } else if (string === "capRound") {
          return Pen.CAP_ROUND;
        } else {
          throw new Error(gxLex.get('invalid.cap.string', string));
        }
      }

      /**
       * Get the integer representation for pen join
       *
       * @private
       * @param {string} string
       * @returns {number}
       */
    }, {
      key: "$decodeJoinString",
      value: function $decodeJoinString(string) {
        if (string === "joinMiter") {
          return Pen.JOIN_MITER;
        } else if (string === "joinRound") {
          return Pen.JOIN_ROUND;
        } else if (string === "joinBevel") {
          return Pen.JOIN_BEVEL;
        } else {
          throw new Error(gxLex.get('invalid.join.string', string));
        }
      }

      /**
       * Returns if the string is a cap string
       * @param {string} string
       * @returns {boolean}
       */
    }, {
      key: "$isCapString",
      value: function $isCapString(string) {
        return string === "capButt" || string === "capSquare" || string === "capRound";
      }

      /**
       * Returns if the string is a join string
       * @param {string} string
       * @returns {boolean}
       */
    }, {
      key: "$isJoinString",
      value: function $isJoinString(string) {
        return string === "joinMiter" || string === "joinRound" || string === "joinBevel";
      }

      /**
       * Returns if the passed string is a valid dash format
       * @param {string} string
       * @returns {boolean}
       */
    }, {
      key: "$isDashString",
      value: function $isDashString(string) {
        return string.indexOf('dash(') === 0;
      }

      /**
       * Get the array representation for the pen dash pattern
       *
       * @private
       * @param {string} string
       * @returns {Array.<number>}
       */
    }, {
      key: "$decodeDashString",
      value: function $decodeDashString(string) {
        var invalidFormat = false,
          dash = [];
        if (string.indexOf('dash(') !== 0) {
          invalidFormat = true;
        }
        if (!invalidFormat) {
          var params = string.match(/\(([^)]+)\)/);
          if (params.length === 2) {
            dash = params[1].split(',').map(baja.Double.DEFAULT.decodeFromString);
          } else {
            invalidFormat = true;
          }
        }
        if (invalidFormat) {
          throw new Error(gxLex.get('invalid.dash.string', string));
        }
        return dash;
      }
    }], [{
      key: "make",
      value: function make() {
        var width,
          cap = Pen.CAP_BUTT,
          join = Pen.JOIN_MITER,
          dash = Pen.noDash;
        for (var _len = arguments.length, pen = new Array(_len), _key = 0; _key < _len; _key++) {
          pen[_key] = arguments[_key];
        }
        if (pen.length === 4) {
          width = pen[0];
          cap = pen[1];
          join = pen[2];
          dash = pen[3];
          return new Pen(width, cap, join, dash);
        } else if (pen.length === 2) {
          width = pen[0];
          dash = pen[1];
          return new Pen(width, Pen.CAP_BUTT, Pen.JOIN_MITER, dash);
        } else if (pen.length === 1) {
          width = pen[0];
          return new Pen(width, Pen.CAP_BUTT, Pen.JOIN_MITER, Pen.noDash);
        }
      }
    }]);
  }(baja.Simple); ////////////////////////////////////////////////////////////////
  // Constants
  ////////////////////////////////////////////////////////////////
  /**
   * Cap options
   */
  Pen.CAP_BUTT = 101;
  Pen.CAP_SQUARE = 102;
  Pen.CAP_ROUND = 103;

  /**
   * Join options
   */
  Pen.JOIN_MITER = 201;
  Pen.JOIN_ROUND = 202;
  Pen.JOIN_BEVEL = 203;

  /**
   * No dash pattern.
   */
  Pen.noDash = [];
  Pen.DEFAULT = new Pen(1.0, Pen.CAP_BUTT, Pen.JOIN_MITER, Pen.noDash);
  function isNumber(number) {
    return typeof number === 'number';
  }

  /**
   * Check if the value is a valid Cap style
   *
   * @param {number} number
   * @returns {boolean}
   */
  function isValidCap(number) {
    return number === Pen.CAP_BUTT || number === Pen.CAP_SQUARE || number === Pen.CAP_ROUND;
  }

  /**
   * Check if the value is a valid Join style
   *
   * @param {number} number
   * @returns {boolean}
   */
  function isValidJoin(number) {
    return number === Pen.JOIN_MITER || number === Pen.JOIN_ROUND || number === Pen.JOIN_BEVEL;
  }

  /**
   * Validate the dash pattern is a valid number array.
   *
   * @param {Array.<number>} dash
   */
  function mustBeNullOrNumberArray(dash) {
    if (dash === null) {
      return;
    }
    if (!Array.isArray(dash)) {
      throw new Error(gxLex.get('pen.dash.error'));
    }
    dash.forEach(function (val, index) {
      if (!isNumber(val)) {
        throw new Error(gxLex.get('pen.dash.content.error', val));
      }
    });
  }
  return Pen;
});
