function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/baja/Insets
 */
define(['baja!', 'lex!gx'], function (baja, lexs) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
    gxLex = _lexs[0];

  /**
   * A javascript based implementation of gx:Insets
   *
   * @class
   * @alias module:nmodule/gx/rc/baja/Insets
   * @extends baja.Simple
   */
  var Insets = /*#__PURE__*/function (_baja$Simple) {
    /**
     * Constructs Insets with the given top, right, bottom and left. Will throw an error if top, right, bottom and left is not a numeric type.
     * Not a number and positive infinite values are accepted.
     *
     * @param {number} top
     * @param {number} right
     * @param {number} bottom
     * @param {number} left
     */
    function Insets(top, right, bottom, left) {
      var _this;
      _classCallCheck(this, Insets);
      _this = _callSuper(this, Insets);
      if (!isNumber(top)) {
        throw new Error(gxLex.get('insets.error', gxLex.get('insets.top'), top));
      }
      if (!isNumber(right)) {
        throw new Error(gxLex.get('insets.error', gxLex.get('insets.right'), right));
      }
      if (!isNumber(bottom)) {
        throw new Error(gxLex.get('insets.error', gxLex.get('insets.bottom'), bottom));
      }
      if (!isNumber(left)) {
        throw new Error(gxLex.get('insets.error', gxLex.get('insets.left'), left));
      }
      _this.$top = top;
      _this.$right = right;
      _this.$bottom = bottom;
      _this.$left = left;
      return _this;
    }

    /**
     * Constructs an Insets with the given top, right, bottom and left; this is an instance method.
     *
     * @example
     * // creates an inset with specified top, right, bottom and left values
     * let insets = Insets.make(100,200,300,400);
     *
     * @example
     * // creates an inset with specified top. In this case the right, bottom and left inset will be defaulted to the top inset value
     * let insets = Insets.make(100);
     *
     * @param   {...number} side
     * @returns {module:nmodule/gx/rc/baja/Insets}
     */
    _inherits(Insets, _baja$Simple);
    return _createClass(Insets, [{
      key: "make",
      value: function make() {
        return Insets.make.apply(Insets, arguments);
      }

      /**
       * Makes an Insets with top, right, bottom and left values
       *
       * @param {number} top
       * @param {number} right
       * @param {number} bottom
       * @param {number} left
       * @returns {module:nmodule/gx/rc/baja/Insets}
       */
    }, {
      key: "getTop",
      value:
      /**
       * Get the top value of the Inset
       *
       * @returns {number}
       */
      function getTop() {
        return this.$top;
      }

      /**
       * Get the right value of the Inset
       *
       * @returns {number}
       */
    }, {
      key: "getRight",
      value: function getRight() {
        return this.$right;
      }

      /**
       * Get the bottom value of the Inset
       *
       * @returns {number}
       */
    }, {
      key: "getBottom",
      value: function getBottom() {
        return this.$bottom;
      }

      /**
       * Get the left value of the Inset
       *
       * @returns {number}
       */
    }, {
      key: "getLeft",
      value: function getLeft() {
        return this.$left;
      }

      /**
       * Encodes the Insets to  "Top Right Bottom Left" format.
       *
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        function checkNaN(side1, side2) {
          return isNaN(side1) && isNaN(side2);
        }
        if (this === Insets.NULL) {
          return 'null';
        }
        var numberEqual = this.$top === this.$bottom && this.$left === this.$right,
          nanEqual = checkNaN(this.$top, this.$bottom) && checkNaN(this.$left, this.$right);
        if (numberEqual || nanEqual) {
          if (this.$top === this.$right || checkNaN(this.$top, this.$right)) {
            return this.$top.encodeToString();
          } else {
            return this.$top.encodeToString() + ' ' + this.$right.encodeToString();
          }
        } else {
          var stringTop = this.$top.encodeToString();
          var stringRight = ' ' + this.$right.encodeToString();
          var stringBottom = ' ' + this.$bottom.encodeToString();
          var stringLeft = ' ' + this.$left.encodeToString();
          return "".concat(stringTop).concat(stringRight).concat(stringBottom).concat(stringLeft);
        }
      }

      /**
       * Converts a string value into an Inset tuple. Throws an error if the string is not in the valid format.
       * @param {string} string
       * @returns {module:nmodule/gx/rc/baja/Insets}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(string) {
        var top, right, bottom, left;
        if (string === 'null') {
          return Insets.NULL;
        }
        var sides = string.split(" ").map(baja.Double.DEFAULT.decodeFromString);
        top = sides[0];
        if (isNumber(sides[1])) {
          right = sides[1];
          if (isNumber(sides[2])) {
            bottom = sides[2];
            if (isNumber(sides[3])) {
              left = sides[3];
              return Insets.make(top, right, bottom, left);
            }
            return Insets.make(top, right, bottom, right);
          }
          return Insets.make(top, right, top, right);
        }
        return Insets.make(top);
      }

      /**
       * @returns {string} a CSS string applicable to padding or margin
       */
    }, {
      key: "toCssString",
      value: function toCssString() {
        return "".concat(this.$top, "px ").concat(this.$right, "px ").concat(this.$bottom, "px ").concat(this.$left, "px");
      }

      /**
       * Applies the insets as padding to the element style.
       * @param {HTMLElement} el
       */
    }, {
      key: "applyPaddingToElement",
      value: function applyPaddingToElement(el) {
        el.style.padding = this.toCssString();
      }

      /**
       * Applies the insets as margin to the element style.
       * @param {HTMLElement} el
       */
    }, {
      key: "applyMarginToElement",
      value: function applyMarginToElement(el) {
        el.style.margin = this.toCssString();
      }

      /**
       * An inset is visible if there is at least one non-zero side.
       * @return {boolean}
       */
    }, {
      key: "isVisible",
      value: function isVisible() {
        return !!(this.$top || this.$right || this.$bottom || this.$left);
      }
    }], [{
      key: "make",
      value: function make() {
        var top, right, bottom, left;
        for (var _len = arguments.length, side = new Array(_len), _key = 0; _key < _len; _key++) {
          side[_key] = arguments[_key];
        }
        if (side.length === 4) {
          top = side[0];
          right = side[1];
          bottom = side[2];
          left = side[3];
        } else if (side.length === 1) {
          top = right = bottom = left = side[0];
        }
        return new Insets(top, right, bottom, left);
      }
    }]);
  }(baja.Simple);
  /**
   * Default value for Insets
   *
   * @type {module:nmodule/gx/rc/baja/Insets}
   */
  Insets.DEFAULT = new Insets(0, 0, 0, 0);

  /**
   * Null value for Insets.
   *
   * @type {module:nmodule/gx/rc/baja/Insets}
   */
  Insets.NULL = new Insets(0, 0, 0, 0);
  function isNumber(number) {
    return typeof number === 'number';
  }
  return Insets;
});
