function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/baja/Font
 */
define(['baja!'], function (baja) {
  'use strict';

  var regex = /(bold|italic|underline)?(\s+)?(bold|italic|underline)?(\s+)?(bold|italic|underline)?(\s+)?([0-9.,]+)pt\s+(.+)/;
  var SERIF_CLASS = 'ux-font-family-serif';
  var SANS_SERIF_CLASS = 'ux-font-family-sans-serif';
  var MONOSPACE_CLASS = 'ux-font-family-monospace';
  var DEFAULT_CLASS = 'defaultNssFont';

  /**
   * @typedef {object} module:nmodule/gx/rc/baja/Font~FontParams
   * @property {string} [name='sans-serif']
   * @property {number} [size=12]
   * @property {string} [unit='pt']
   * @property {boolean} [bold=false]
   * @property {boolean} [italic=false]
   * @property {boolean} [underline=false]
   */

  /**
   * BajaScript representation of a `gx:Font`.
   *
   * @class
   * @alias module:nmodule/gx/rc/baja/Font
   * @extends baja.Simple
   */
  var Font = /*#__PURE__*/function (_baja$Simple) {
    /**
     * @private
     * @param {module:nmodule/gx/rc/baja/Font~FontParams} [params]
     */
    function Font() {
      var _this;
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _classCallCheck(this, Font);
      _this = _callSuper(this, Font);
      var _params$name = params.name,
        name = _params$name === void 0 ? 'sans-serif' : _params$name,
        _params$size = params.size,
        size = _params$size === void 0 ? 12 : _params$size,
        _params$unit = params.unit,
        unit = _params$unit === void 0 ? 'pt' : _params$unit,
        italic = params.italic,
        bold = params.bold,
        underline = params.underline;
      name = name && name.trim();
      if (!name) {
        throw new Error("name required");
      }
      _this.$name = name;
      _this.$size = size;
      _this.$unit = unit;
      _this.$italic = !!italic;
      _this.$bold = !!bold;
      _this.$underline = !!underline;
      return _this;
    }

    /**
     * @param {module:nmodule/gx/rc/baja/Font~FontParams} [params]
     * @returns {module:nmodule/gx/rc/baja/Font}
     */
    _inherits(Font, _baja$Simple);
    return _createClass(Font, [{
      key: "make",
      value:
      /**
       * @param {module:nmodule/gx/rc/baja/Font~FontParams} [params]
       * @returns {module:nmodule/gx/rc/baja/Font}
       */
      function make(params) {
        return Font.make(params);
      }

      /**
       * @returns {string} the name of the font
       */
    }, {
      key: "getName",
      value: function getName() {
        return this.$name;
      }

      /**
       * @returns {string} the name of the font, safe to apply as part of a CSS
       * font-family
       */
    }, {
      key: "getCssSafeName",
      value: function getCssSafeName() {
        var name = this.$name;
        switch (name.toLowerCase()) {
          case 'sansserif':
            return 'sans-serif';
          case 'monospaced':
            return 'monospace';
          default:
            return name;
        }
      }

      /**
       * @returns {number} the size of the font
       */
    }, {
      key: "getSize",
      value: function getSize() {
        return this.$size;
      }

      /**
       * @returns {string} the units in which the font is sized (note that
       * anything other than `pt` is not supported server-side)
       */
    }, {
      key: "getUnit",
      value: function getUnit() {
        return this.$unit;
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "isBold",
      value: function isBold() {
        return this.$bold;
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "isItalic",
      value: function isItalic() {
        return this.$italic;
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "isUnderline",
      value: function isUnderline() {
        return this.$underline;
      }

      /**
       * @param {object} [params]
       * @param {string} [params.fallback="sans-serif"] a fallback font family
       * @returns {object} an object with `fontFamily`, `fontSize`, `fontStyle`,
       * `fontWeight`, and `textDecoration` properties to be applied to an element
       * style
       */
    }, {
      key: "toCss",
      value: function toCss() {
        var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$fallback = _ref.fallback,
          fallback = _ref$fallback === void 0 ? 'sans-serif' : _ref$fallback;
        var isNull = this.isNull();
        var fontFamily;
        if (this.isFontFamily() || isNull) {
          fontFamily = '';
        } else {
          fontFamily = this.getCssSafeName();
          if (fontFamily.includes(' ')) {
            fontFamily = "\"".concat(fontFamily, "\"");
          }
          if (fontFamily !== fallback) {
            fontFamily = "".concat(fontFamily, ", ").concat(fallback);
          }
        }
        var fontSize, fontStyle, fontWeight, textDecoration;
        if (isNull) {
          fontSize = '';
          fontStyle = '';
          fontWeight = '';
          textDecoration = '';
        } else {
          var unit = this.$unit;
          //TODO: may need actual pts someday
          fontSize = "".concat(this.$size).concat(unit === 'pt' ? 'px' : unit);
          fontStyle = this.$italic ? 'italic' : 'normal';
          fontWeight = this.$bold ? 'bold' : 'normal';
          textDecoration = this.$underline ? 'underline' : 'none';
        }
        return {
          fontFamily: fontFamily,
          fontSize: fontSize,
          fontStyle: fontStyle,
          fontWeight: fontWeight,
          textDecoration: textDecoration
        };
      }

      /**
       * @returns {boolean} true if this represents a font family (e.g.
       * sans-serif); false if this is a concrete font
       */
    }, {
      key: "isFontFamily",
      value: function isFontFamily() {
        switch (this.$name.toLowerCase()) {
          case 'sansserif':
          case 'sans-serif':
          case 'monospaced':
          case 'monospace':
          case 'serif':
            return true;
          default:
            return false;
        }
      }

      /**
       * @returns {string|null} a CSS class name that will allow this font to be
       * determined by the theme (i.e. this represents a font family or null,
       * instead of a concrete font). Return null if not themable.
       */
    }, {
      key: "toClassName",
      value: function toClassName() {
        if (this.isNull()) {
          return DEFAULT_CLASS;
        }
        switch (this.$name.toLowerCase()) {
          case 'sansserif':
          case 'sans-serif':
            return SANS_SERIF_CLASS;
          case 'monospaced':
          case 'monospace':
            return MONOSPACE_CLASS;
          case 'serif':
            return SERIF_CLASS;
          default:
            return null;
        }
      }

      /**
       * Applies style and class names to
       * @param {Element} el
       * @param {object} [params]
       * @param {string} [params.fallback="sans-serif"] a fallback font family
       */
    }, {
      key: "applyToElement",
      value: function applyToElement(el) {
        var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          fallback = _ref2.fallback;
        var classList = el.classList,
          style = el.style;
        classList.remove(SERIF_CLASS, SANS_SERIF_CLASS, MONOSPACE_CLASS, DEFAULT_CLASS);
        var className = this.toClassName();
        if (className) {
          classList.add(className);
        }
        Object.assign(style, this.toCss({
          fallback: fallback
        }));
      }

      /**
       * @param {string} str
       * @returns {module:nmodule/gx/rc/baja/Font}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        if (str === 'null') {
          return Font.NULL;
        }
        var match = regex.exec(str);
        if (!match) {
          throw new Error("invalid font string \"".concat(str, "\""));
        }
        var obj = {
          size: parseFloat(match[7]),
          name: match[8]
        };

        //bold/italic/underline
        obj[match[1]] = !!match[1];
        obj[match[3]] = !!match[3];
        obj[match[5]] = !!match[5];
        return Font.make(obj);
      }

      /**
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this.isNull()) {
          return 'null';
        }
        var str = '';
        if (this.$bold) {
          str += 'bold ';
        }
        if (this.$italic) {
          str += 'italic ';
        }
        if (this.$underline) {
          str += 'underline ';
        }
        str += this.$size + 'pt ' + this.$name;
        return str;
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "isNull",
      value: function isNull() {
        return this === Font.NULL;
      }
    }], [{
      key: "make",
      value: function make(params) {
        if (typeof params === 'string') {
          return Font.DEFAULT.decodeFromString(params);
        }
        return new Font(params);
      }
    }]);
  }(baja.Simple);
  Font.DEFAULT = Font.make({
    name: 'sans-serif',
    size: 12
  });
  Font.NULL = Font.make({
    name: 'null',
    size: 0
  });
  return Font;
});
