function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/baja/Color
 */
define(['baja!', 'nmodule/gx/rc/util/colorUtils'], function (baja, colorUtils) {
  'use strict';

  var parseRgba = colorUtils.parseRgba,
    toRgbCssString = colorUtils.toRgbCssString;
  var cache = {};

  /**
   * @alias module:nmodule/gx/rc/baja/Color
   * @extends baja.Simple
   */
  var Color = /*#__PURE__*/function (_baja$Simple) {
    /**
     * @param {number} rgba the RGBA numbers representing this color (all 0-255)
     * @param {string} [str] the string encoding if known; otherwise will be
     * generated from the rgba numbers
     */
    function Color(rgba, str) {
      var _this;
      _classCallCheck(this, Color);
      _this = _callSuper(this, Color);
      _this.$str = str;
      _this.$rgba = rgba;
      return _this;
    }

    /**
     * @param {string|object|number[]} str string encoding, or an object
     * with `r`, `g`, `b`, and/or `a` properties, or an array of values
     * @returns {module:nmodule/gx/rc/baja/Color}
     */
    _inherits(Color, _baja$Simple);
    return _createClass(Color, [{
      key: "make",
      value:
      /**
       * @param {string} str
       * @returns {module:nmodule/gx/rc/baja/Color}
       */
      function make(str) {
        return Color.make(str);
      }

      /**
       ** @param str
       * @returns {module:nmodule/gx/rc/baja/Color}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        return Color.make(str);
      }

      /**
       * @returns {string} the color encoded to string. `#rrggbb` format if alpha
       * is 255; `#aarrggbb` format otherwise
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        var str = this.$str;
        if (!str) {
          var alpha = this.getAlpha();
          str = toHex(this.getRed()) + toHex(this.getGreen()) + toHex(this.getBlue());
          if (alpha !== 255) {
            str = toHex(alpha) + str;
          }
          str = '#' + str;
          this.$str = str;
        }
        return str;
      }

      /**
       * @returns {number} red [0-255]
       */
    }, {
      key: "getRed",
      value: function getRed() {
        return this.$rgba[0];
      }

      /**
       * @returns {number} green [0-255]
       */
    }, {
      key: "getGreen",
      value: function getGreen() {
        return this.$rgba[1];
      }

      /**
       * @returns {number} blue [0-255]
       */
    }, {
      key: "getBlue",
      value: function getBlue() {
        return this.$rgba[2];
      }

      /**
       * @returns {number} alpha [0-255]
       */
    }, {
      key: "getAlpha",
      value: function getAlpha() {
        return this.$rgba[3];
      }
    }, {
      key: "getRgba",
      value: function getRgba() {
        return this.$rgba.slice();
      }

      /**
       * @returns {string} a CSS-compatible string representing this color
       */
    }, {
      key: "toCssString",
      value: function toCssString() {
        return toRgbCssString(this.$rgba);
      }

      /**
       * @returns {string} a CSS-compatible string representing this color
       */
    }, {
      key: "toString",
      value: function toString() {
        return this.toCssString();
      }
    }], [{
      key: "make",
      value: function make(str) {
        if (str === 'null' || !str) {
          return Color.NULL;
        }
        var rgba;
        if (Array.isArray(str)) {
          rgba = str.slice();
          if (rgba.length === 3) {
            rgba.push(0xff);
          }
        } else if (_typeof(str) === 'object') {
          var _str$r = str.r,
            r = _str$r === void 0 ? 0 : _str$r,
            _str$g = str.g,
            g = _str$g === void 0 ? 0 : _str$g,
            _str$b = str.b,
            b = _str$b === void 0 ? 0 : _str$b,
            _str$a = str.a,
            a = _str$a === void 0 ? 0xff : _str$a;
          rgba = [r, g, b, a];
        } else {
          rgba = parseRgba(str);
        }
        var key = rgba.join();
        return cache[key] || (cache[key] = new Color(rgba));
      }
    }]);
  }(baja.Simple);
  Color.DEFAULT = Color.make('black');
  Color.NULL = new Color([0, 0, 0, 0], 'null');
  function toHex(n) {
    var str = n.toString(16).toLowerCase();
    if (str.length === 1) {
      str = '0' + str;
    }
    return str;
  }
  return Color;
});
