function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

define(['bajaux/Widget', 'bajaux/spandrel/buildConfig', 'jquery', 'underscore'], function (Widget, buildConfig, $, _) {
  'use strict';

  var $IS_DYNAMIC_SYMBOL = buildConfig.$IS_DYNAMIC_SYMBOL;
  var compact = _.compact;
  var BOOLEAN_ATTRIBUTES = ['checked', 'disabled', 'draggable', 'indeterminate', 'multiple', 'readonly', 'selected'];

  /**
   * @private
   * @exports bajaux/spandrel/util
   */
  var exports = {};
  exports.camelCase = function (kebabCase) {
    return kebabCase.replace(/^-*/, '').replace(/-./g, function (s) {
      return s[1].toUpperCase();
    });
  };

  /**
   * Get the Spandrel widget that contains or is mounted in this DOM element.
   *
   * @param {JQuery|HTMLElement} dom
   * @returns {module:bajaux/spandrel/SpandrelWidget|undefined}
   */
  exports.getContainingSpandrelWidget = function (dom) {
    dom = $(dom).closest('.bajaux-initialized');
    var w = Widget["in"](dom);
    while (dom.length && !(w.queryWidgets || dom[0].spandrelKey)) {
      dom = dom.parent().closest('.bajaux-initialized');
      w = Widget["in"](dom);
    }
    // noinspection JSValidateTypes
    return w;
  };
  exports.getInlineStyles = function (el) {
    var style = el.style;
    var result = {};
    for (var i = 0, len = style.length; i < len; ++i) {
      var prop = exports.camelCase(style[i]);
      result[prop] = style[prop];
    }
    return result;
  };

  /**
   * @param {module:bajaux/spandrel/SpandrelWidget} parentWidget
   * @param {module:bajaux/spandrel/SpandrelWidget} childWidget
   * @returns {string[]} the path of keys from the parent to the child, that is,
   * `parentWidget.queryWidget(path.join('/'))` would return this child.
   */
  exports.getPathToKid = function (parentWidget, childWidget) {
    var path = [],
      w = childWidget;
    while (w && w.jq() && w.jq().length && w !== parentWidget) {
      path.push(w.jq()[0].spandrelKey);
      w = exports.getContainingSpandrelWidget(w.jq().parent());
    }
    return path.reverse();
  };

  /**
   * @param {module:bajaux/Widget|function} w a Widget instance or constructor
   * @returns {boolean} true if the widget is a dynamic spandrel widget
   */
  exports.isDynamic = function (w) {
    return !!(w && w[$IS_DYNAMIC_SYMBOL]);
  };

  /**
   * @param {HTMLElement} node
   * @param {string} key desired {@link module:bajaux/spandrel~Member member} key, or '*'
   * to match any
   * @returns {Array.<HTMLElement>}
   */
  exports.kidsMatching = function (node, key) {
    if (!node) {
      return [];
    }
    key = String(key);
    return Array.prototype.slice.call(node.childNodes).filter(function (n) {
      var nodeKey = n.spandrelKey;
      return key === '*' || key === nodeKey;
    });
  };

  /**
   * @param {string} path path of keys e.g. `a/b/c`
   * @param {string} pattern query pattern, e.g. `a/&#42;/c`
   * @returns {boolean} true if the path matches the pattern
   */
  exports.pathMatches = function (path, pattern) {
    if (path === pattern) {
      return true;
    }
    var pathMembers = path.split('/'),
      patternMembers = pattern.split('/');
    var pathIndex = 0;
    for (var i = 0, len = patternMembers.length; i < len; ++i, ++pathIndex) {
      var patternMember = patternMembers[i],
        pathMember = pathMembers[pathIndex];
      switch (patternMember) {
        case '*':
          break;
        //match any
        case '**':
          var nextPatternMember = patternMembers[++i];
          if (!nextPatternMember) {
            return true; //ending in globstar is a match
          }
          //advance to next match
          if (nextPatternMember !== '*') {
            while (pathMember && pathMember !== nextPatternMember) {
              pathMember = pathMembers[++pathIndex];
            }
            if (!pathMember) {
              return false; //no match found
            }
          }
          if (nextPatternMember === '*' && i === patternMembers.length - 1) {
            return true;
          }
          //???
          break;
        default:
          if (patternMember !== pathMember) {
            return false;
          }
      }
    }
    //true if we hit every member in the path without failures
    return pathIndex >= pathMembers.length;
  };

  /**
   * Returns true if the element has changed in a way that would require a
   * Widget inside it to be torn down and rebuilt. Currently, a change in tag
   * name or addition/removal of the element itself would require a rebuild.
   * Changes in properties such as `class` would not require a rebuild.
   *
   * @param {HTMLElement} newElement
   * @param {HTMLElement} oldElement
   * @returns {boolean}
   */
  exports.requiresRebuild = function (oldElement, newElement) {
    return !(newElement && oldElement) || newElement.tagName !== oldElement.tagName;
  };

  /**
   * Updates one HTMLElement to look like the second. If the structures of the
   * two elements are appreciably different, this will throw an error, so ensure
   * `requiresRebuild` does not return true before calling this.
   *
   * @param {HTMLElement} newElement
   * @param {HTMLElement} oldElement
   * @param {object} properties the Properties of the widget to live in the
   * element
   */
  exports.updateElement = function (oldElement, newElement, properties) {
    if (newElement.nodeType === Node.TEXT_NODE) {
      oldElement.textContent = newElement.textContent;
      return;
    }

    // for a dynamic spandrel element, do not update class/style as these are
    // accounted for by spandrel itself.
    var isSpandrelElement = !!oldElement[$IS_DYNAMIC_SYMBOL];
    var oldAttrs = oldElement.attributes || [];
    for (var i = 0, len = oldAttrs.length; i < len; i++) {
      var name = oldAttrs[i].name;
      if (isSpandrelElement && (name === 'class' || name === 'style')) {
        continue;
      }
      if (!newElement.hasAttribute(name)) {
        oldElement.removeAttribute(name);
        i--;
        len--;
      }
    }
    var newAttrs = newElement.attributes || [];
    for (var _i = 0, _len = newAttrs.length; _i < _len; _i++) {
      var _newAttrs$_i = newAttrs[_i],
        _name = _newAttrs$_i.name,
        value = _newAttrs$_i.value;
      if (isSpandrelElement && (_name === 'class' || _name === 'style')) {
        continue;
      }
      if (_name === 'class') {
        updateClasses(oldElement, newElement, properties);
      } else {
        oldElement.setAttribute(_name, value);
        // update the underlying DOM value of an INPUT tag
        if (_name === 'value' && oldElement.tagName.toLowerCase() === 'input') {
          oldElement.value = value;
        }
      }
    }

    //pick up expandos
    Object.assign(oldElement, newElement);
    for (var _i2 = 0, _len2 = BOOLEAN_ATTRIBUTES.length; _i2 < _len2; ++_i2) {
      var attr = BOOLEAN_ATTRIBUTES[_i2];
      oldElement[attr] = newElement[attr];
    }
    var rootCssClass = properties && properties.rootCssClass;
    if (!rootCssClass) {
      var w = Widget["in"](oldElement);
      rootCssClass = w && w.properties().getValue('rootCssClass');
    }
    if (rootCssClass) {
      var _oldElement$classList;
      (_oldElement$classList = oldElement.classList).add.apply(_oldElement$classList, _toConsumableArray(compact(rootCssClass.split(' '))));
    }
    var newKids = newElement.childNodes;
    var oldKids = oldElement.childNodes;
    var newLen = newKids.length;
    var oldLen = oldKids.length;
    for (var _i3 = 0, _len3 = Math.max(newLen, oldLen); _i3 < _len3; _i3++) {
      var oldKid = oldKids[_i3];
      var newKid = newKids[_i3];

      // for the purposes of diffing, we will treat text content as an
      // 'attribute' and update it. child elements will not be added or removed.
      if (oldKid && newKid) {
        exports.updateElement(oldKids[_i3], newKids[_i3]);
      } else if (!oldKid && isTextNode(newKid)) {
        oldElement.appendChild(newKid);
      } else if (!newKid && isTextNode(oldKid)) {
        oldElement.removeChild(oldKid);
      }
    }
  };
  function updateClasses(oldElement, newElement, properties) {
    var _oldElement$classList2;
    var classesToKeep = [];
    oldElement.classList.forEach(function (c) {
      return c.startsWith('bajaux-') && classesToKeep.push(c);
    });

    // for a regular Widget, it can apply classes during doInitialize, so we
    // can't wipe them. it's expected that it will toggle its own classes
    // during load.
    if (properties && properties.$keepClassNames) {
      newElement.classList.forEach(function (c) {
        return classesToKeep.push(c);
      });
    } else {
      // if the existing widget is a spandrel widget, apply the new class list
      // directly. it's expected that the spandrel widget will use rootCssClass.
      oldElement.setAttribute('class', newElement.getAttribute('class'));
    }
    (_oldElement$classList2 = oldElement.classList).add.apply(_oldElement$classList2, classesToKeep);
  }
  function isTextNode(el) {
    return el && el.nodeType === Node.TEXT_NODE;
  }
  return exports;
});
