/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * Defines the valid arguments the user may pass to a `spandrel` call. This may
 * be a string, object, or array (to define a static widget), or a function
 * (to define a dynamic widget).
 *
 * @typedef {(String|Array.<String|Object>|Object|Function)} module:bajaux/spandrel~SpandrelArg
 */

/**
 * Defines the internal structure for one Spandrel widget. A Spandrel widget
 * consists of a set of zero or more child widgets (`members`) and a set of zero
 * or more event handlers (`on`) that apply at its own level.
 *
 * @typedef {object} module:bajaux/spandrel~BuildContext
 * @property {Array.<module:bajaux/spandrel~Member>} members
 * @property {Array} on
 */

/**
 * Defines one member of a composite Spandrel widget. Each one has a unique
 * identifying key (these are numbers increasing if configured as an array;
 * object keys if configured as an object literal). The config property is
 * what will be passed to `manager.buildFor()` to construct the widget. These
 * can also be nested using the `kids` property, in which case the nested
 * widgets will also be Spandrel composites.
 *
 * @typedef {object} module:bajaux/spandrel~Member
 * @property {string} key
 * @property {module:bajaux/lifecycle/WidgetManager~BuildParams} config
 * @property {Array.<module:bajaux/spandrel~BuildContext>} [config.kids]
 */

//TODO: this probably goes to Widget/BaseWidget
/**
 * Describes the current state of a widget.
 *
 * @typedef {object} module:bajaux/spandrel~WidgetState
 * @property {module:bajaux/commands/CommandGroup} commands the widget's Commands
 * @property {boolean} enabled true if the widget is enabled (but you probably
 * want `writable` instead)
 * @property {string} formFactor the widget's form factor
 * @property {object} props the widget's Properties, as a key-value map
 * @property {boolean} readonly true if the widget is readonly (but you probably
 * want `writable` instead)
 * @property {HTMLElement|null} rootElement a copy of the element in which the
 * widget is currently initialized; or `null` if the widget has not yet been
 * initialized. Please note the word "copy!" You can alter the `rootElement`'s
 * `classList` and `style` attributes and they will be applied to the real
 * element; however things like event listeners must be applied in
 * `doInitialize` or use the built-in spandrel event handling functionality.
 * @property {boolean} writable true if the widget is enabled and not readonly
 */

/**
 * Describes valid properties to assign to a DOM element when creating spandrel
 * data from JSX.
 *
 * @typedef {object} module:bajaux/spandrel/jsx~Props
 * @property {object|string} [style] the style attribute may be a map of CSS
 * properties to their string values. Any properties with a falsy value will not
 * be applied.
 * @property {string} [className] use `className` instead of `class` to specify
 * CSS classes
 * @property {string} [tagName='div'] when constructing a Widget directly, a DOM
 * element will be dynamically generated in which to instantiate it. The tag
 * name of the element may be specified. `style`, `className` and other
 * attributes will be applied to it as normal.
 * @property {string} [spandrelKey] for ease of use when using `queryWidget`,
 * the `spandrelKey` may be applied to a DOM element or a Widget.
 * @property {object} [spandrelSrc] when using a data type that provides its own
 * `spandrel` data, such as `UxModel`, you may apply it directly to a DOM
 * element as a `spandrelSrc` attribute. The object must have a `toSpandrel`
 * function, that will be called using the DOM element you're generating:
 * `spandrelSrc.toSpandrel({ dom })`.
 */
