function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

define(['bajaux/spandrel/buildConfig', 'bajaux/spandrel/util', 'underscore'], function (buildConfig, util, _) {
  'use strict';

  var $IS_SPANDREL_SYMBOL = buildConfig.$IS_SPANDREL_SYMBOL,
    $KEY_SYMBOL = buildConfig.$KEY_SYMBOL;
  var isDynamic = util.isDynamic;
  var WIDGET_ATTRIBUTES = {
    enabled: true,
    formFactor: true,
    properties: true,
    readonly: true,
    value: true
  };

  /**
   * API Status: **Development**
   * @exports bajaux/spandrel/jsx
   */
  var exports = {};

  /**
   * @param {string|Function} type
   * @param {object|null} props
   * @param kids
   * @returns {module:bajaux/spandrel~SpandrelArg}
   */
  function jsxToSpandrel(type, props, kids) {
    var dom, widgetType;
    props = props || {};
    var _props = props,
      spandrelKey = _props.spandrelKey,
      spandrelSrc = _props.spandrelSrc;
    if (typeof type === 'string') {
      dom = document.createElement(type);
    } else {
      dom = document.createElement(props.tagName || 'div');
      widgetType = type;
    }
    setProps(dom, props, !!widgetType);
    if (spandrelSrc) {
      if (kids.length) {
        throw new Error('spandrelSrc cannot be combined with children');
      }
      if (typeof type !== 'string') {
        throw new Error('spandrelSrc can only be applied to a DOM element');
      }
      var sp = spandrelSrc.toSpandrel({
        dom: dom
      });
      if (_typeof(sp) === 'object' && !Array.isArray(sp)) {
        sp[$IS_SPANDREL_SYMBOL] = true;
        if (spandrelKey) {
          sp[$KEY_SYMBOL] = spandrelKey;
        }
      }
      return sp;
    }
    var _props2 = props,
      enabled = _props2.enabled,
      formFactor = _props2.formFactor,
      properties = _props2.properties,
      readonly = _props2.readonly,
      value = _props2.value;
    if (typeof enabled === 'string') {
      enabled = enabled !== 'false';
    }
    if (typeof readonly === 'string') {
      readonly = readonly !== 'false';
    }
    if (typeof value === 'undefined' && isDynamic(type)) {
      value = null;
    }
    if (!kids.length) {
      kids = undefined;
    } else {
      kids.forEach(function (kid, i) {
        if (!kid) {
          return;
        }
        if (typeof kid === 'string') {
          dom.appendChild(document.createTextNode(kid));
          kids = undefined;
        } else {
          kid.key = kid.key || String(i);
        }
      });
    }
    return _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({}, $IS_SPANDREL_SYMBOL, true), $KEY_SYMBOL, spandrelKey), "dom", dom), "enabled", enabled), "formFactor", formFactor), "kids", kids), "properties", properties), "readonly", readonly), "type", widgetType), "value", value);
  }
  function setProps(el, props, isWidget) {
    Object.keys(props).forEach(function (name) {
      return setProp(el, name, props[name], isWidget);
    });
  }
  function setProp(el, name, value, isWidget) {
    if (isWidget && WIDGET_ATTRIBUTES[name]) {
      return;
    }
    if (name === '$init') {
      return value(el);
    }
    if (name === 'spandrelKey' || name === 'spandrelSrc') {
      return;
    }
    if (name === 'className') {
      name = 'class';
    }
    if (name === 'style' && _typeof(value) === 'object') {
      var style = el.style;
      Object.keys(value).forEach(function (prop) {
        style[prop] = value[prop];
      });
    } else if (typeof value === 'boolean') {
      if (value) {
        el.setAttribute(name, true);
      }
      el[name] = value;
    } else {
      el.setAttribute(name, value);
    }
  }

  /**
   * @param {string|Function} type HTML tag name, or a Widget constructor to instantiate
   * @param {object|null} props
   * @param {Array.<object>} children
   * @returns {module:bajaux/spandrel~SpandrelArg}
   *
   * @example
   * <caption>Basic JSX->spandrel example</caption>
   * &#37;** @jsx spandrel.jsx *&#37;
   * class ComponentToHTML extends spandrel((comp) => {
   *   return (
   *     <table>
   *     {
   *       comp.getSlots().properties().toArray().map((prop) => {
   *         return <tr>
   *           <td>{ prop.getName() }</td>
   *           <td>{ prop.getType() }</td>
   *         </tr>;
   *       })
   *     }
   *     </table>
   *   );
   * }) {}
   */
  exports.jsxToSpandrel = function (type, props) {
    for (var _len = arguments.length, children = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      children[_key - 2] = arguments[_key];
    }
    return jsxToSpandrel(type, props, _.flatten(children));
  };
  return exports;
});
