function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * @private
 * @module bajaux/spandrel/buildConfig
 */
define(['Promise', 'underscore'], function (Promise, _) {
  'use strict';

  var KEY_SYMBOL = Symbol('spandrelKey');
  var IS_SPANDREL_SYMBOL = Symbol('isSpandrel');
  var IS_DYNAMIC_SYMBOL = Symbol('isDynamic');
  var ROOT_SYMBOL = Symbol('spandrelRoot');
  var DEPTH_SYMBOL = Symbol('spandrelDepth');

  /**
   * Given spandrel input (potentially dynamically generated), spit out a JSON
   * array, where each member may potentially contain more nested data, that
   * will map to one or more fe.buildFor calls.
   *
   * @private
   * @alias module:bajaux/spandrel/buildConfig
   * @param {string|Array.<object>|Object} arg
   * @param {module:bajaux/spandrel~WidgetState} widgetState configuration data derived
   * from the parent widget to contain all these spandrel-generated widgets
   * @returns {Promise.<module:bajaux/spandrel~BuildContext>}
   */
  function buildConfig(arg) {
    var widgetState = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    widgetState = _.extend({
      props: widgetState.properties
    }, widgetState);
    var normalizedOn;
    var handleArg = function handleArg(spandrelArg, key) {
      key = String(spandrelArg && spandrelArg[KEY_SYMBOL] || key);
      return Promise.resolve(handleSpandrelArg(spandrelArg, key, widgetState)).then(function (member) {
        if (!spandrelArg) {
          return member;
        }
        normalizedOn = (normalizedOn || []).concat(normalizeOn(spandrelArg.on, key));
        return member;
      });
    };
    if (isHtml(arg) || !arg) {
      return Promise.all([handleArg(arg, 0)]).then(function (members) {
        return {
          members: members,
          on: []
        };
      });
    }
    if (Array.isArray(arg)) {
      return Promise.all(arg.map(handleArg)).then(function (members) {
        return {
          members: members,
          on: normalizedOn
        };
      });
    }
    if (_typeof(arg) === 'object') {
      if (arg[IS_SPANDREL_SYMBOL]) {
        return buildConfig([arg]);
      }
      var on = arg.on,
        kids = arg.kids;
      if (kids || on) {
        if (arg.dom) {
          // if dom is specified, we want one kid widget, with kids built under that.
          return Promise.all([handleArg(arg, '0')]).then(function (members) {
            return {
              members: members,
              on: normalizedOn
            };
          });
        } else {
          normalizedOn = normalizeOn(on);
          // if no dom is specified, we want kids built directly.
          return Promise.all(_.map(kids, function (kid, key) {
            return handleArg(kid, String(key));
          })).then(function (members) {
            return {
              members: members,
              on: normalizedOn
            };
          });
        }
      }
      return Promise.all(Object.keys(arg).map(function (k) {
        return handleArg(arg[k], k);
      })).then(function (members) {
        return {
          members: members,
          on: normalizedOn || []
        };
      });
    }
    return Promise.reject(new Error('cannot configure spandrel widget from ' + arg));
  }

  /**
   * @param {Array} on the `on` event handlers as provided by the user. The
   * members may be of the form `[ event, handler ]` or `[ event, selector, handler ]`.
   * @param {string} [key] since the result handlers will be applied one level
   * up, if the input handlers should apply only to one nested widget key, the
   * key will be prepended to the selectors.
   * @returns {Array} the normalized `on` event handler arrays to be included
   * in the final BuildContext.
   */
  function normalizeOn(on, key) {
    if (!on || !on.length) {
      return [];
    }
    if (!Array.isArray(on[0])) {
      on = [on];
    }
    return on.map(function (on) {
      var _on = _slicedToArray(on, 3),
        event = _on[0],
        selector = _on[1],
        handler = _on[2];
      if (on.length < 3) {
        handler = selector;
        if (key) {
          selector = key + '/**/*';
        } else {
          selector = '**/*';
        }
      } else {
        if (key) {
          selector = key + '/' + selector;
        }
      }
      return [event, selector, handler];
    });
  }

  /**
   * Spandrel can take string values, arrays of values, or key -> value maps.
   * This function will handle one value in a potential collection of
   * arguments.
   *
   * @param {string|object} spandrelArg
   * @param {string} key
   * @param {object} widgetState
   * @returns {object|Promise.<object>} object with key and config properties
   */
  function handleSpandrelArg(spandrelArg, key, widgetState) {
    if (!spandrelArg) {
      return {
        key: key,
        config: {
          dom: '<wbr style="display: none;">'
        }
      };
    }
    if (isHtml(spandrelArg)) {
      return {
        key: key,
        config: rawStringToConfig(spandrelArg, widgetState)
      };
    } else {
      if (spandrelArg.key && spandrelArg.config) {
        //already a spandrel object
        //TODO: use a non-enumerable property instead of guessing
        return spandrelArg;
      }
      return Promise.resolve(objectToConfig(spandrelArg, widgetState)).then(function (config) {
        return {
          key: key,
          config: config
        };
      });
    }
  }
  function isHtml(dom) {
    return typeof dom === 'string' || dom instanceof Element;
  }

  /**
   * @param str raw html
   * @param widgetState parent widget config
   * @returns {object} config object that can be passed to fe.buildFor
   */
  function rawStringToConfig(str, widgetState) {
    return {
      dom: str,
      formFactor: 'mini'
    };
  }

  /**
   * @param spandrelArg arg as given to spandrel
   * @param widgetState parent widget config
   * @returns {object|Promise.<object>} config object that can be passed to
   * fe.buildFor
   */
  function objectToConfig(spandrelArg, widgetState) {
    var kids = spandrelArg.kids;
    var widgetProps = widgetState.properties;
    var argProps = spandrelArg.properties;
    if (typeof argProps === 'function') {
      argProps = argProps(_.extend({}, widgetProps));
    } else if (argProps === 'inherit') {
      argProps = widgetProps;
    }
    var config = _.extend({}, spandrelArg, {
      formFactor: spandrelArg.formFactor || 'mini'
    });
    if (argProps) {
      config.properties = argProps;
    }
    if (config.readonly === 'inherit' || config.readonly === undefined) {
      config.readonly = widgetState.readonly;
    }
    if (config.enabled === 'inherit' || config.enabled === undefined) {
      config.enabled = widgetState.enabled;
    }
    config.writable = config.enabled && !config.readonly;
    if (kids) {
      return buildConfig(kids, config).then(function (kids) {
        return _.extend(_.omit(config, 'on'), {
          kids: kids
        });
      });
    }
    return _.omit(config, 'on');
  }

  // make these invisible until explicitly needed to be public
  // store the spandrel key on the DOM element itself
  Object.defineProperty(buildConfig, '$KEY_SYMBOL', {
    value: KEY_SYMBOL
  });

  // mark an object as spandrel data
  Object.defineProperty(buildConfig, '$IS_SPANDREL_SYMBOL', {
    value: IS_SPANDREL_SYMBOL
  });

  // mark a DOM element, widget instance, or widget constructor as a dynamic spandrel widget
  Object.defineProperty(buildConfig, '$IS_DYNAMIC_SYMBOL', {
    value: IS_DYNAMIC_SYMBOL
  });

  // store a reference to the root spandrel widget on one of its descendents
  Object.defineProperty(buildConfig, '$ROOT_SYMBOL', {
    value: ROOT_SYMBOL
  });

  // store a spandrel widget's depth within the tree (root === 0)
  Object.defineProperty(buildConfig, '$DEPTH_SYMBOL', {
    value: DEPTH_SYMBOL
  });
  return buildConfig;
});
