function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module bajaux/spandrel/SpandrelWidget
 */
define(['bajaux/Widget', 'bajaux/events', 'Promise', 'underscore', 'bajaux/spandrel/util'], function (Widget, events, Promise, _, util) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var compact = _.compact,
    filter = _.filter,
    flatten = _.flatten,
    map = _.map,
    omit = _.omit;
  var kidsMatching = util.kidsMatching,
    pathMatches = util.pathMatches;
  var SWALLOWED_MODIFY = Symbol('swallowedModify');
  var NON_INHERITABLE_PROPERTIES = ['rootCssClass'];

  /**
   * @class
   * @alias module:bajaux/spandrel/SpandrelWidget
   * @extends module:bajaux/Widget
   */
  return /*#__PURE__*/function (_Widget) {
    function SpandrelWidget() {
      _classCallCheck(this, SpandrelWidget);
      return _callSuper(this, SpandrelWidget, arguments);
    }
    _inherits(SpandrelWidget, _Widget);
    return _createClass(SpandrelWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;
        dom.on(MODIFY_EVENT, function (e) {
          // i need to listen for modify events from child elements, and mark
          // myself modified when i get one. but i can't just return false,
          // because events from deeper down in the tree of spandrel widgets need
          // to bubble up so the spandrel-native handlers higher up still work.
          // like for on: [ MODIFY_EVENT, '**/foo', () => {} ], events need to
          // bubble up from the nested foo widget.
          //
          // but if i let everything bubble willy nilly, then the events double-up
          // and i wind up with a O(n^2) performance problem.
          //
          // so i mark the event as "swallowed" so it still bubbles but doesn't
          // trigger any parent widgets to call setModified() forever.
          //
          // e.target === dom[0] when it's the event from my own setModified call.
          if (e.target !== dom[0] && !e[SWALLOWED_MODIFY]) {
            e[SWALLOWED_MODIFY] = true;
            _this.setModified(true);
          }
        });
        return _superPropGet(SpandrelWidget, "doInitialize", this, 3)(arguments);
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return Promise.all(map(this.jq().children(), function (e) {
          var widget = Widget["in"](e);
          if (widget) {
            return widget.destroy();
          }
        }));
      }
    }, {
      key: "doChanged",
      value: function doChanged() {
        return this.rerender && this.rerender();
      }

      /**
       * @param {module:bajaux/Widget} kid
       * @returns {Array.<string>}
       */
    }, {
      key: "getPathToKid",
      value: function getPathToKid(kid) {
        if (kid === this) {
          return [];
        }
        var path = util.getPathToKid(this, kid);
        if (!path.length) {
          throw new Error('kid not actual child of this widget');
        }
        return path;
      }

      /**
       * @param {string} queryString a string, /-separated, to match spandrel keys
       * through the entire nested structure
       * @returns {module:bajaux/Widget|undefined} the first matching widget
       */
    }, {
      key: "queryWidget",
      value: function queryWidget(queryString) {
        return this.queryWidgets(queryString)[0];
      }

      /**
       * @param {string} queryString a string, /-separated, to match spandrel keys
       * through the entire nested structure
       * @returns {Array.<module:bajaux/Widget>} matching widgets
       */
    }, {
      key: "queryWidgets",
      value: function queryWidgets(queryString) {
        var _this2 = this;
        queryString = String(queryString);
        var widgets = /** @type {Array.<module:bajaux/Widget>} */[this];
        if (!queryString) {
          return widgets;
        }
        if (queryString.match(/\*\*/)) {
          //slow globbing
          return filter(this.jq().find('.bajaux-initialized'), function (el) {
            return el.spandrelKey;
          }).map(Widget["in"]).filter(function (w) {
            return pathMatches(util.getPathToKid(_this2, w).join('/'), queryString);
          });
        }
        queryString.split('/').forEach(function (key) {
          widgets = flatten(widgets.map(function (widget) {
            return kidsMatching(widget && widget.jq()[0], key).map(Widget["in"]);
          }));
        });
        return compact(widgets);
      }

      /**
       * @returns {module:bajaux/spandrel~WidgetState} widget state
       */
    }, {
      key: "state",
      value: function state(key, value) {
        switch (arguments.length) {
          case 0:
            var props = omit(this.properties().toObject(), NON_INHERITABLE_PROPERTIES),
              enabled = this.isEnabled(),
              readonly = this.isReadonly(),
              jq = this.jq();
            return _.extend({
              commands: this.getCommandGroup(),
              enabled: enabled,
              formFactor: this.getFormFactor(),
              modified: this.isModified(),
              properties: props,
              props: props,
              readonly: readonly,
              rootElement: jq && jq[0],
              writable: enabled && !readonly
            }, this.$state);
          case 1:
            if (!key || _typeof(key) !== 'object') {
              throw new Error('state map required');
            }
            this.$state = _.extend(this.$state || {}, key);
        }
      }
    }], [{
      key: "mixin",
      value: function mixin(Ctor) {
        var spandrelProt = SpandrelWidget.prototype;
        var ctorProt = Ctor.prototype;
        Object.getOwnPropertyNames(spandrelProt).forEach(function (method) {
          if (method === 'constructor') {
            return;
          }
          if (method.startsWith('do')) {
            var ctorMethod = ctorProt[method];
            var spandrelMethod = spandrelProt[method];
            ctorProt[method] = function () {
              var _this3 = this;
              for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
              }
              return Promise.resolve(ctorMethod && ctorMethod.apply(this, args)).then(function () {
                return spandrelMethod.apply(_this3, args);
              });
            };
          } else {
            ctorProt[method] = spandrelProt[method];
          }
        });
      }
    }]);
  }(Widget);
});
