/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module bajaux/dragdrop/StringEnvelope
 */
define(['Promise', 'bajaux/dragdrop/Envelope'], function (Promise, Envelope) {
  'use strict';

  /**
   * Envelope for simply transferring an array of strings.
   * 
   * @class
   * @extends module:bajaux/dragdrop/Envelope
   * @alias module:bajaux/dragdrop/StringEnvelope
   * @param {Array.<String>} arr the strings contained in this envelope. (Any
   * non-Strings will be toString-ed.)
   */
  var StringEnvelope = function StringEnvelope(arr) {
    Envelope.apply(this, arguments);
    if (!Array.isArray(arr)) {
      throw new Error('array required');
    }
    this.$arr = arr.map(String);
  };
  StringEnvelope.prototype = Object.create(Envelope.prototype);
  StringEnvelope.prototype.constructor = StringEnvelope;

  /**
   * @returns {string} `niagara/strings`
   */
  StringEnvelope.prototype.getMimeType = function () {
    return 'niagara/strings';
  };

  /**
   * The strings contained in the envelope (for simple strings, the JSON
   * and values are the same).
   * 
   * @returns {Promise} promise to be resolved with an array of strings
   */
  StringEnvelope.prototype.toJson = function () {
    return Promise.resolve(this.$arr.slice());
  };

  /**
   * The strings contained in the envelope (for simple strings, the JSON
   * and values are the same).
   *
   * @returns {Promise} promise to be resolved with an array of strings
   */
  StringEnvelope.prototype.toValues = function () {
    return Promise.resolve(this.$arr.slice());
  };
  return StringEnvelope;
});
