/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview RefreshButton class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'lex!mobile', 'jquery', 'jquerymobile', 'Promise', 'mobile/px/widgets/Button'], function (baja, lexs, $, jqm, Promise, Button) {
  "use strict";

  var callSuper = baja.callSuper,
    mobileLex = lexs[0];

  /**
   * @class RefreshButton
   *
   * The Widget that represents Niagara's 'kitPx:RefreshButton' Type.
   *
   * @name RefreshButton
   * @extends Button
   */
  function RefreshButton() {
    callSuper(RefreshButton, this, arguments);
  }
  baja.subclass(RefreshButton, Button);

  /**
   * Called when the widget is first loaded.
   */
  RefreshButton.prototype.load = function () {
    callSuper("load", RefreshButton, this, arguments);

    // By default, always set this as enabled when first loaded.
    this.setEnabled(true);
  };

  /**
   * Append the Widget's DOM content onto the specified DOM element.
   *
   * @param {Function} hasUpdate
   */
  RefreshButton.prototype.doUpdate = function (hasUpdate) {
    var that = this;
    return Promise.resolve(callSuper("doUpdate", RefreshButton, that, arguments)).then(function () {
      if (hasUpdate("text")) {
        // The text always says refresh
        that.setText(mobileLex.get("refresh"));
      }
    });
  };

  /**
   * Handle a UI Widget event.
   */
  RefreshButton.prototype.doHandleEvent = function (eventName) {
    // Refresh the page
    this.getRootContainer().refresh();

    // Return true so the event doesn't filter down to the bindings
    return true;
  };
  return RefreshButton;
});
