/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview IgnoreWidget class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'mobile/px/widgets/Widget'], function (baja, $, jqm, Widget) {
  "use strict";

  var noop = baja.noop;

  /**
   * @class IgnoreWidget.
   * 
   * There are several Widgets we don't want to throw errors for when loading and ignore.
   * This JS Constructor is registered on these Widgets.
   *
   * @name IgnoreWidget
   * @extends Widget
   */
  function IgnoreWidget() {
    baja.callSuper(IgnoreWidget, this, arguments);
  }
  baja.subclass(IgnoreWidget, Widget);

  /**
   * Append the Widget's DOM content onto the specified DOM element.
   *
   * @param {Object} dom DOM element to append content too.
   */
  IgnoreWidget.prototype.load = noop;

  /**
   * Load the child Widgets.
   * 
   * {@link baja.Widget#load} must be called before this method is invoked.
   */
  IgnoreWidget.prototype.loadChildren = noop;

  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} [hasUpdate] called to test whether a 
   *                               given Property can update the DOM.
   */
  IgnoreWidget.prototype.doUpdate = noop;
  return IgnoreWidget;
});
