/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview Include this file to register all available implementations
 * of gx classes to their corresponding Baja types via baja.registerType().
 * 
 * @author Logan Byam
 * @version 0.0.2.0
 */
define(['baja!', 'baja!bajaui:Layout,gx:Brush,gx:Color,gx:Font,gx:Insets,gx:Size', 'underscore', 'mobile/px/gx/Brush', 'mobile/px/gx/Color', 'mobile/px/gx/Font', 'mobile/px/gx/Insets', 'mobile/px/gx/Layout', 'mobile/px/gx/Size'], function (baja, types, _, Brush, Color, Font, Insets, Layout, Size) {
  "use strict";

  return function registerGx() {
    _.each({
      'gx:Brush': Brush,
      'gx:Color': Color,
      'gx:Font': Font,
      'gx:Insets': Insets,
      'bajaui:Layout': Layout,
      'gx:Size': Size
    }, function (ctor, typeSpec) {
      return baja.registerType(typeSpec, function () {
        return ctor;
      });
    });
  };
});
