/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview IStatusToSimple class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/converters/Converter'], function (baja, Converter) {
  "use strict";

  /**
   * @class BIStatus To Simple Converter.
   * 
   * A Component that represents a Niagara 'converters:BIStatusToSimple' Type.
   * 
   * Please note, this doesn't work properly since BajaScript Components don't have
   * properly implement BIStatus like their Java counterparts.
   *
   * @name IStatusToSimple
   * @extends Converter
   */
  function IStatusToSimple() {
    IStatusToSimple.$super.apply(this, arguments);
  }
  baja.subclass(IStatusToSimple, Converter);

  /**
   * Convert the first object to the second object and return the result.
   *
   * @param {baja.Object} from.
   * @param {baja.Object} to.
   * @param {OrdTarget} target.
   * @returns {baja.Simple} a simple value read from one of the converter's
   * `disabled`, `fault`, etc. slots depending on the given status
   */
  IStatusToSimple.prototype.convert = function (from, to, target) {
    var status = baja.Status.getStatusFromIStatus(from),
      that = this,
      result;
    if (status.isDisabled()) {
      result = that.getDisabled();
    } else if (status.isFault()) {
      result = that.getFault();
    } else if (status.isDown()) {
      result = that.getDown();
    } else if (status.isAlarm()) {
      result = that.getAlarm();
    } else if (status.isStale()) {
      result = that.getStale();
    } else if (status.isOverridden()) {
      result = that.getOverridden();
    } else if (status.isUnackedAlarm()) {
      result = that.getUnackedAlarm();
    } else if (status.isNull()) {
      result = that.getNullStatus();
    } else {
      result = to;
    }
    return result;
  };
  return IStatusToSimple;
});
