/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview IEnumToSimple class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/converters/Converter'], function (baja, Converter) {
  "use strict";

  /**
   * @class IEnum To Simple Converter.
   * 
   * A Component that represents a Niagara 'converters:BIEnumToSimple' Type.
   * 
   * Please note, this doesn't work properly since BajaScript Components don't have
   * properly implement BIEnum like their Java counterparts.
   *
   * @name IEnumToSimple
   * @extends Converter
   */
  function IEnumToSimple() {
    baja.callSuper(IEnumToSimple, this, arguments);
  }
  baja.subclass(IEnumToSimple, Converter);

  /**
   * Convert the first object to the second object and return the result.
   *
   * @param {baja.Object} from.
   * @param {baja.Object} to.
   * @param {OrdTarget} target.
   * @return {baja.Simple} a simple value read from the converter's
   * `EnumToSimpleMap`, depending on the enum read from the converted
   * value
   */
  IEnumToSimple.prototype.convert = function (from, to, target) {
    // Find the enum
    var val = baja.Enum.getEnumFromIEnum(from),
      // Get the Simple from the map
      simple = this.getMap().get(val.getOrdinal());
    if (simple === null) {
      // Default back if we can't find anything
      simple = to;
    }
    return simple;
  };
  return IEnumToSimple;
});
