/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview WbFieldEditorBinding class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/fieldeditors/fieldeditors', 'mobile/fieldeditors/fieldeditors.mobile',
//unused in code - but don't remove!
'mobile/px/bindings/Binding'], function (baja, fe, mobileFE, Binding) {
  "use strict";

  var callSuper = baja.callSuper;

  /**
   * @class WbFieldEditorBinding.
   * 
   * A Component that represents a Niagara 'workbench:WbFieldEditorBinding' Type.
   */
  function WbFieldEditorBinding() {
    callSuper(WbFieldEditorBinding, this, arguments);
  }
  baja.subclass(WbFieldEditorBinding, Binding);

  /**
   * Called when the Widget is loaded.
   */
  WbFieldEditorBinding.prototype.doLoad = function () {
    if (!this.isBound()) {
      return;
    }
    var widget = this.getWidget(),
      that = this,
      target = this.$target,
      propertyPath = target.propertyPath,
      val,
      slot,
      parent;
    function loadedFieldEditor() {
      // Set the field editor to readonly if need be
      //      widget.$fieldEditor.setReadonly(!widget.isEnabled());

      // Update the Widget now the field editor has loaded           
      return that.update();
    }
    if (widget && widget.getType().is("kitPx:GenericFieldEditor")) {
      // If the field editor is already loaded then we don't need to build any of the html again
      if (widget.$fieldEditor) {
        return loadedFieldEditor();
      }

      // Find the container and slot
      parent = target.getComponent();
      baja.iterate(propertyPath, 0, propertyPath.length - 1, function (prop) {
        parent = parent.get(prop);
      });
      slot = propertyPath[propertyPath.length - 1];
      val = parent.get(slot);
      return fe.makeFor({
        value: val,
        container: parent,
        slot: slot,
        readonly: !widget.isEnabled(),
        element: widget.getDomElement()
      }).then(function (fe) {
        widget.$fieldEditor = fe;
        return loadedFieldEditor();
      })["catch"](function (err) {
        baja.error("Failed to create field editor: " + err);
      });
    }
  };

  /**
   * Called when the binding is updated.
   */
  WbFieldEditorBinding.prototype.update = function (firstUpdate) {
    // Bail on the first update since doLoad will cause an update instead
    if (firstUpdate) {
      return;
    }

    // Load the value into the field editor
    if (this.isBound()) {
      var widget = this.getWidget();
      if (widget && widget.getType().is("kitPx:GenericFieldEditor") && widget.$fieldEditor && !widget.isModified()) {
        widget.$fieldEditor.load(this.$target.getObject());
      }
    }

    // Call super
    return callSuper("update", WbFieldEditorBinding, this, arguments);
  };
  return WbFieldEditorBinding;
});
