/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview BoundLabelBinding class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/util.px', 'mobile/px/bindings/ValueBinding'], function (baja, pxUtil, ValueBinding) {
  "use strict";

  var getStatusBrush = pxUtil.getStatusBrush;

  /**
   * @class BoundLabelBinding.
   * 
   * A Component that represents a Niagara 'bajaui:BoundLabelBinding' Type.
   *
   * @name BoundLabelBinding
   * @extends ValueBinding
   */
  function BoundLabelBinding() {
    baja.callSuper(BoundLabelBinding, this, arguments);
  }
  baja.subclass(BoundLabelBinding, ValueBinding);

  /**
   * Return true if the Property is overridden.
   *
   * @param {baja.Property} prop the Property to test.
   * @return {Boolean} return true if the Property is overridden.
   */
  BoundLabelBinding.prototype.isOverridden = function (prop) {
    // Call super method
    var isOver = BoundLabelBinding.$super.prototype.isOverridden.apply(this, arguments);
    if (this.isBound() && !isOver && !this.getStatusEffect().is("none")) {
      var val = this.$target.getObject();

      // Value must implement BIStatus      
      if (val.getType().is("baja:IStatus")) {
        var nm = prop.getName();
        if (nm === "blink" || nm === "foreground" || nm === "background") {
          isOver = true;
        }
      }
    }
    return isOver;
  };

  /**
   * Return any override display String for the given Property.
   *
   * @param {baja.Property|String} prop the Widget's Property to return the overridden value for.
   * @return {String} the overridden value.
   */
  BoundLabelBinding.prototype.getOnWidget = function (prop) {
    var effect = this.getStatusEffect(),
      val = this.$target.getObject();
    if (prop && this.isBound() && val.getType().is("baja:IStatus") && !effect.is("none")) {
      var nm = prop.getName(),
        status = baja.Status.getStatusFromIStatus(val);
      if (nm === "blink") {
        if (status.isUnackedAlarm() && effect.is("colorAndBlink")) {
          return true;
        }
      } else if (nm === "foreground") {
        var fg = getStatusBrush({
          status: status,
          isForeground: true
        });
        if (fg !== null) {
          return fg;
        }
      } else if (nm === "background") {
        var bg = getStatusBrush({
          status: status,
          isForeground: false
        });
        if (bg !== null) {
          return bg;
        }
      }
    }

    // Call super method
    return baja.callSuper("getOnWidget", BoundLabelBinding, this, arguments);
  };
  return BoundLabelBinding;
});
