/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/nrio/rc/fe/NrioShunt500OhmConversionEditor
 */
define(['baja!',
  'Promise',
  'jquery',
  'nmodule/driver/rc/fe/ProxyConversionEditor',
  'nmodule/webEditors/rc/servlets/registry',
  'nmodule/nrio/rc/baja/NrioShunt500OhmConversion',
  'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function
  (baja,
   Promise,
   $,
   ProxyConversionEditor,
   registry,
   NrioShunt500OhmConversion,
   typeUtils) {

  'use strict';

  /**
   * Editor for handling `nrio:NrioShunt500OhmConversion` values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/nrio/rc/fe/NrioShunt500OhmConversionEditor
   */
  var NrioShunt500OhmConversionEditor = function NrioShunt500OhmConversionEditor(params) {
    ProxyConversionEditor.apply(this, arguments);
  };
  NrioShunt500OhmConversionEditor.prototype = Object.create(ProxyConversionEditor.prototype);
  NrioShunt500OhmConversionEditor.prototype.constructor = NrioShunt500OhmConversionEditor;

  /**
   * @override
   * @see module:nmodule/driver/rc/fe/ProxyConversionEditor #getProxyConvTypes
   * @returns {Promise|*} Types or promise that resolves to ProxyConversion list of types of driver, kitIo and nrio modules
   */
  ProxyConversionEditor.prototype.getProxyConvTypes = function () {
    return registry.getTypes({
      targetType: 'driver:ProxyConversion',
      showAbstract: false,
      modules: ["driver", "kitIo", "nrio"]
    });
  };

  NrioShunt500OhmConversionEditor.prototype.doLoad = function (value) {
    var that = this;
    return typeUtils.importTypes(value.getSubConvTypeSpec())
      .then(function (loadedType) {
        var val = baja.$(loadedType).decodeFromString(value.getSubConvValStr());
        return ProxyConversionEditor.prototype.doLoad.call(that, val);
      });
  };

  NrioShunt500OhmConversionEditor.prototype.doRead = function () {
    var that = this;
    var conWid = that.getConversionWidget();
    if (conWid) {
      return conWid.read()
        .then(function (subVal) {
          return NrioShunt500OhmConversion.make(subVal.getType().getTypeSpec(), subVal.encodeToString());
        });
    }
    return NrioShunt500OhmConversion.make(that.getSelect().val());
  };

  return NrioShunt500OhmConversionEditor;
});
