function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/widget/ControlPanelWidget
 */
define(['baja!', 'baja!videoDriver:VideoZoomEnum,videoDriver:VideoPanTiltEnum', 'bajaux/mixin/subscriberMixIn', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/util/CommandButtonGroup', 'Promise', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/videoDriver/rc/rpc/rpc', 'bajaux/mixin/responsiveMixIn', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, types, subscriberMixIn, Command, CommandGroup, CommandButtonGroup, Promise, BaseEditor, fe, rpc, responsiveMixIn) {
  'use strict';

  var tpl = function tpl() {
    return "<div class=\"ControlPanelContainer\">\n                        <div class=\"controls panRight\"/>\n                        <div class=\"controls panRightTiltUp\" />    \n                        <div class=\"controls tiltUp\" />\n                        <div class=\"controls panLeftTiltUp\" />\n                        <div class=\"controls panLeft\" />\n                        <div class=\"controls panLeftTiltDown\" />\n                        <div class=\"controls tiltDown\" />\n                        <div class=\"controls panRightTiltDown\" />\n                        <div class=\"controls zoomControls\" />                        \n                      </div>";
  };
  var move = rpc.move,
    zoom = rpc.zoom;
  var NONE_INTERVAL = 200;
  /**
   * Widget for controlling the pan, tilt and zoom of a chosen camera. Handles
   * slow, medium and fast pan and tilt of a camera. Handles mediumZoomIn and mediumZoomOut
   * of a camera.
   *
   * @class
   * @alias module:nmodule/videoDriver/rc/widget/ControlPanelWidget
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */
  return /*#__PURE__*/function (_BaseEditor) {
    function ControlPanelWidget(params) {
      var _this;
      _classCallCheck(this, ControlPanelWidget);
      _this = _callSuper(this, ControlPanelWidget, [params]);
      subscriberMixIn(_this);
      responsiveMixIn(_this, {
        'xxsmall-fit': function xxsmallFit(jq) {
          return Math.min(jq.width, jq.height) <= 50;
        },
        'xsmall-fit': function xsmallFit(jq) {
          return Math.min(jq.width, jq.height) > 50 && Math.min(jq.width, jq.height) <= 150;
        },
        'small-fit': function smallFit(jq) {
          return Math.min(jq.width, jq.height) > 150 && Math.min(jq.width, jq.height) <= 200;
        },
        'medium-fit': function mediumFit(jq) {
          return Math.min(jq.width, jq.height) > 200 && Math.min(jq.width, jq.height) <= 300;
        },
        'medium-large-fit': function mediumLargeFit(jq) {
          return Math.min(jq.width, jq.height) > 300 && Math.min(jq.width, jq.height) <= 400;
        },
        'large-fit': function largeFit(jq) {
          return Math.min(jq.width, jq.height) > 400 && Math.min(jq.width, jq.height) <= 500;
        },
        'xlarge-fit': function xlargeFit(jq) {
          return Math.min(jq.width, jq.height) > 500 && Math.min(jq.width, jq.height) <= 600;
        },
        'xxlarge-fit': function xxlargeFit(jq) {
          return Math.min(jq.width, jq.height) > 600 && Math.min(jq.width, jq.height) <= 700;
        },
        'xxxlarge-fit': function xxxlargeFit(jq) {
          return Math.min(jq.width, jq.height) > 700 && Math.min(jq.width, jq.height) <= 800;
        },
        'free-fit': function freeFit(jq) {
          return Math.min(jq.width, jq.height) > 800;
        }
      });
      return _this;
    }

    /**
     * Gives out a command with a user specified handler.
     *
     * @private
     * @param {string} lex
     * @param {Function} func
     * @returns {module:bajaux/commands/Command}
     */
    _inherits(ControlPanelWidget, _BaseEditor);
    return _createClass(ControlPanelWidget, [{
      key: "$cmd",
      value: function $cmd(lex, func) {
        return new Command({
          module: 'videoDriver',
          lex: lex,
          func: func
        });
      }
    }, {
      key: "$makeCmdGrp",
      value:
      /**
       * Returns a command group with the input command array.
       *
       * @private
       * @param {Array<module:bajaux/commands/Command>} cmdArr
       * @returns {module:bajaux/commands/CommandGroup}
       */
      function $makeCmdGrp(cmdArr) {
        return new CommandGroup({
          commands: cmdArr
        });
      }
    }, {
      key: "$makeCommandsForPanTilt",
      value:
      /**
       * Makes the command objects to interact with Pan and Tilt options of a camera.
       *
       * @private
       * @returns {baja.OrderedMap} groupCmdMap - OrderedMap with Pan and Tilt Commands.
       */
      function $makeCommandsForPanTilt() {
        var _this2 = this;
        var cmdArr = [],
          groupCmdMap = new baja.OrderedMap(),
          videoPanTiltEnum = baja.$('videoDriver:VideoPanTiltEnum'),
          ordinalLength = videoPanTiltEnum.getRange().getOrdinals().length - 1;

        // Enum 'None" is not considered.
        var _loop = function _loop() {
          var curEnum = videoPanTiltEnum.make(ordinalIndex),
            tag = curEnum.getTag();
          var inCmd = _this2.$cmd(tag, function () {
            move(_this2.value().getNavOrd(), tag);
            _this2.$triggerNoneMoveCommand();
          });
          cmdArr.push(inCmd);
          // Segregating the slow, medium, fast commands to an independent command group.
          // For every index (3, 6, 9, 12, 15, 18, 21, 24) of the fast command, modulus will be returning a zero.
          if (ordinalIndex % 3 === 0) {
            // Use the class name without the 'speed' operator.
            var className = tag.replace('Fast', '');
            groupCmdMap.put(className, _this2.$makeCmdGrp(cmdArr));
            cmdArr = [];
          }
        };
        for (var ordinalIndex = 1; ordinalIndex <= ordinalLength; ordinalIndex++) {
          _loop();
        }
        return groupCmdMap;
      }

      /**
       * @private
       */
    }, {
      key: "$triggerNoneZoomCommand",
      value: function $triggerNoneZoomCommand() {
        var _this3 = this;
        setTimeout(function () {
          return zoom(_this3.value().getNavOrd(), 'none');
        }, NONE_INTERVAL);
      }

      /**
       * @private
       */
    }, {
      key: "$triggerNoneMoveCommand",
      value: function $triggerNoneMoveCommand() {
        var _this4 = this;
        setTimeout(function () {
          return move(_this4.value().getNavOrd(), 'none');
        }, NONE_INTERVAL);
      }

      /**
       * Makes the command object for zoom.
       *
       * @returns {baja.OrderedMap} zoomMap - OrderedMap of zoomInMedium and zoomOutMedium commands.
       */
    }, {
      key: "$makeCommandsForZoom",
      value: function $makeCommandsForZoom() {
        var _this5 = this;
        var cmdArr = [this.$cmd('videoDriver.zoomIn', function () {
          zoom(_this5.value().getNavOrd(), 'zoomInMedium');
          _this5.$triggerNoneZoomCommand();
        }), this.$cmd('videoDriver.zoomOut', function () {
          zoom(_this5.value().getNavOrd(), 'zoomOutMedium');
          _this5.$triggerNoneZoomCommand();
        })];
        var zoomMap = new baja.OrderedMap();
        zoomMap.put('zoom', this.$makeCmdGrp(cmdArr));
        return zoomMap;
      }

      /**
       * Lifecycle initialize method.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this6 = this;
        dom.addClass('ControlPanelWidget').html(tpl());
        this.$panTiltCmdMap = this.$makeCommandsForPanTilt();
        this.$zoomControlMap = this.$makeCommandsForZoom();
        var promiseArr = [];
        this.$panTiltCmdMap.getKeys().forEach(function (className) {
          promiseArr.push(fe.buildFor({
            dom: _this6.jq().find('.' + className),
            value: _this6.$panTiltCmdMap.get(className),
            type: CommandButtonGroup,
            properties: {
              toolbar: true
            },
            formFactor: 'mini'
          }));
        });
        promiseArr.push(fe.buildFor({
          dom: this.jq().find('.zoomControls'),
          value: this.$zoomControlMap.get('zoom'),
          type: CommandButtonGroup,
          properties: {
            toolbar: true
          },
          formFactor: 'mini'
        }));
        return Promise.all(promiseArr);
      }

      /**
       * Returns the pan and tilt command OrderedMap.
       *
       * @returns {baja.OrderedMap} panTiltCmdMap - OrderedMap with Pan and Tilt Commands.
       */
    }, {
      key: "getPanTiltCommands",
      value: function getPanTiltCommands() {
        return this.$panTiltCmdMap;
      }

      /**
       * Returns the zoomInMedium and zoomOutMedium command group.
       *
       * @returns {baja.OrderedMap}
       */
    }, {
      key: "getZoomCommands",
      value: function getZoomCommands() {
        return this.$zoomControlMap;
      }

      /**
       * Destroys the dom and associated child elements.
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('ControlPanelWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);
  }(BaseEditor);
});
