function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/live/stream/StreamSettingsWidget
 */
define(['baja!', 'baja!videoDriver:VideoCompressionEnum,videoDriver:VideoFrameRateEnum,' + 'videoDriver:VideoResolutionEnum', 'lex!videoDriver', 'log!nmodule.videoDriver.rc.fe.playback.StreamSettingsWidget', 'bajaux/events', 'nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin', 'nmodule/videoDriver/rc/live/stream/StreamSettings', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function (baja, types, lexs, log, events, StreamConfigurationMixin, StreamSettings, CompositeEditor, CompositeBuilder, mixinUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    videoDriverLex = _lexs[0];
  var MODIFY_EVENT = events.MODIFY_EVENT;
  var hasMixin = mixinUtils.hasMixin;
  var BANDWIDTH_DISPLAY_CHANGE_EVENT = StreamConfigurationMixin.BANDWIDTH_DISPLAY_CHANGE_EVENT,
    MIXIN_NAME = StreamConfigurationMixin.MIXIN_NAME;
  var logSevere = log.severe.bind(log);
  var KEYS_TO_TYPE = {
    'preferredResolution': 'videoDriver:VideoResolutionEnum',
    'preferredFrameRate': 'videoDriver:VideoFrameRateEnum',
    'preferredCompression': 'videoDriver:VideoCompressionEnum'
  };
  var getKeys = function getKeys() {
    return Object.keys(KEYS_TO_TYPE);
  };
  var tpl = function tpl(_ref) {
    var bandwidthDisplay = _ref.bandwidthDisplay,
      preferredResolution = _ref.preferredResolution,
      preferredFrameRate = _ref.preferredFrameRate,
      preferredCompression = _ref.preferredCompression;
    return "\n    <table class=\"ux-table\">\n      <tr class=\"ux-table-row\"><td>".concat(bandwidthDisplay, "</td><td class=\"bandwidthDisplay\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(preferredResolution, "</td><td class=\"preferredResolution\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(preferredFrameRate, "</td><td class=\"preferredFrameRate\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(preferredCompression, "</td><td class=\"preferredCompression\"></td></tr>\n    </table>");
  };

  /**
   * Allows configuration of video stream quality settings.
   *
   * @class
   * @alias module:nmodule/videoDriver/rc/live/stream/StreamSettingsWidget
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */
  return /*#__PURE__*/function (_CompositeEditor) {
    function StreamSettingsWidget() {
      _classCallCheck(this, StreamSettingsWidget);
      return _callSuper(this, StreamSettingsWidget, arguments);
    }
    _inherits(StreamSettingsWidget, _CompositeEditor);
    return _createClass(StreamSettingsWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;
        dom.addClass('StreamSettingsWidget').html(tpl({
          bandwidthDisplay: videoDriverLex.getSafe('bandwidthDisplay'),
          preferredResolution: videoDriverLex.getSafe('preferredResolution'),
          preferredFrameRate: videoDriverLex.getSafe('preferredFrameRate'),
          preferredCompression: videoDriverLex.getSafe('preferredCompression')
        }));
        dom.on(MODIFY_EVENT, '*', function () {
          _this.read().then(function (settings) {
            return Promise.all([_this.value().applyStreamSettings(settings), settings.saveToUserData()]);
          })["catch"](logSevere);
        });
      }

      /**
       * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder} a builder
       * to show selectors for each stream setting property
       */
    }, {
      key: "makeBuilder",
      value: function makeBuilder() {
        var _this2 = this;
        var builder = new CompositeBuilder();
        builder.getKeys = getKeys;
        builder.getDomFor = function (key) {
          return _this2.jq().find('.' + key);
        };
        builder.getValueFor = function (key) {
          return baja.$(KEYS_TO_TYPE[key], _this2.$defaultSettings[key]);
        };
        builder.getConfigFor = function () {
          return {
            formFactor: 'mini'
          };
        };
        return builder;
      }

      /**
       * Load in the current configured settings (either saved by the user, or
       * defaults from the stream).
       *
       * @param {module:nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin} videoStream
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(videoStream) {
        var _this3 = this,
          _arguments = arguments;
        if (!hasMixin(videoStream, MIXIN_NAME)) {
          throw new Error('StreamConfigurationMixin required');
        }
        var bandwidthListener = this.$bandwidthListener = function (display) {
          return _this3.$setBandwidthDisplay(display);
        };
        videoStream.on(BANDWIDTH_DISPLAY_CHANGE_EVENT, bandwidthListener);
        return StreamSettings.make(videoStream).then(function (defaultSettings) {
          _this3.$defaultSettings = defaultSettings;
          return _superPropGet(StreamSettingsWidget, "doLoad", _this3, 3)(_arguments);
        });
      }

      /**
       * Read user-entered settings.
       * @returns {Promise<module:nmodule/videoDriver/rc/live/stream/StreamSettings>}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var keys = getKeys();
        var builder = this.getBuilder();
        return Promise.all(keys.map(function (key) {
          return builder.getEditorFor(key).read();
        })).then(function (enums) {
          var settings = {};
          keys.forEach(function (key, i) {
            settings[key] = enums[i].getTag();
          });
          return new StreamSettings(settings);
        });
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var videoStream = this.value();
        if (videoStream) {
          videoStream.removeListener(BANDWIDTH_DISPLAY_CHANGE_EVENT, this.$bandwidthListener);
        }
        this.jq().removeClass('StreamSettingsWidget');
        return _superPropGet(StreamSettingsWidget, "doDestroy", this, 3)([]);
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getBandwidthDisplayElement",
      value: function $getBandwidthDisplayElement() {
        return this.jq().find('.bandwidthDisplay');
      }

      /**
       * @private
       * @param {string} bandwidthDisplay
       */
    }, {
      key: "$setBandwidthDisplay",
      value: function $setBandwidthDisplay(bandwidthDisplay) {
        this.$getBandwidthDisplayElement().text(bandwidthDisplay);
      }
    }]);
  }(CompositeEditor);
});
