function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/live/stream/StreamSettings
 */
define(['underscore', 'nmodule/webEditors/rc/servlets/userData'], function (_, userData) {
  'use strict';

  var USER_DATA_KEY = 'VideoStreamSettings';
  var DEFAULT_RESOLUTION = 'high';
  var DEFAULT_FRAME_RATE = 'high';
  var DEFAULT_COMPRESSION = 'medium';

  /**
   * Stream quality settings.
   *
   * @class
   * @alias module:nmodule/videoDriver/rc/live/stream/StreamSettings
   */
  return /*#__PURE__*/function () {
    /**
     * @param [params]
     * @param {string} params.preferredResolution a tag from `videoDriver:VideoResolutionEnum`
     * @param {string} params.preferredFrameRate a tag from `videoDriver:VideoFrameRateEnum`
     * @param {string} params.preferredCompression a tag from `videoDriver:VideoCompressionEnum`
     */
    function StreamSettings() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _classCallCheck(this, StreamSettings);
      /** @type {string} */
      this.preferredResolution = params.preferredResolution || DEFAULT_RESOLUTION;
      /** @type {string} */
      this.preferredFrameRate = params.preferredFrameRate || DEFAULT_FRAME_RATE;
      /** @type {string} */
      this.preferredCompression = params.preferredCompression || DEFAULT_COMPRESSION;
    }

    /**
     * Retrieve the stream settings for this `VideoStream`. Will use the
     * settings saved by the user if present; otherwise lets the `VideoStream`
     * provide its own defaults.
     *
     * @param {module:nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin} videoStream
     * @returns {Promise.<module:nmodule/videoDriver/rc/live/stream/StreamSettings>}
     */
    return _createClass(StreamSettings, [{
      key: "saveToUserData",
      value:
      /**
       * Persist these settings to user data.
       *
       * @returns {Promise}
       */
      function saveToUserData() {
        return userData.put(USER_DATA_KEY, JSON.stringify(this));
      }
    }], [{
      key: "make",
      value: function make(videoStream) {
        return userData.get(USER_DATA_KEY).then(function (userSettings) {
          if (userSettings) {
            return new StreamSettings(JSON.parse(userSettings));
          }
          return videoStream.getDefaultStreamSettings();
        }).then(function (settings) {
          return new StreamSettings(settings || {});
        });
      }
    }]);
  }();
});
