function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/live/stream/BandwidthMonitor
 */
define([], function () {
  'use strict';

  /**
   * Monitors the bandwidth of a media stream.
   *
   * @class
   * @alias module:nmodule/videoDriver/rc/live/stream/BandwidthMonitor
   */
  return /*#__PURE__*/function () {
    /**
     * @param {object} [params]
     * @param {number} [params.window=10000} rolling window, in ms, in which to
     * monitor bandwidth. Data entries older than this window will be discarded.
     */
    function BandwidthMonitor() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$window = _ref.window,
        window = _ref$window === void 0 ? 10000 : _ref$window;
      _classCallCheck(this, BandwidthMonitor);
      this.$window = window;
      this.$chunks = [];
      this.$first = true;
    }

    /**
     * Log a chunk of bytes. Call this once per frame, or on an interval, when
     * you know how much data has been transmitted since the last chunk.
     * @param {number} bytes
     */
    return _createClass(BandwidthMonitor, [{
      key: "logBytes",
      value: function logBytes(bytes) {
        var timestamp;
        if (typeof bytes === 'number') {
          timestamp = +new Date();
        } else {
          timestamp = bytes.timestamp;
          bytes = bytes.bytes;
        }
        var now = +new Date();
        var window = this.$window;
        var withinWindow = function withinWindow(_ref2) {
          var timestamp = _ref2.timestamp;
          return now - timestamp <= window;
        };
        var chunk = {
          bytes: bytes,
          timestamp: timestamp
        };
        if (this.$first) {
          chunk.first = true;
          this.$first = false;
        }
        this.$chunks = this.$chunks.filter(withinWindow).concat(chunk);
      }

      /**
       * @returns {number} total number of bytes recorded within the window
       */
    }, {
      key: "getTotalBytes",
      value: function getTotalBytes() {
        return this.$chunks.reduce(function (sum, _ref3) {
          var bytes = _ref3.bytes,
            first = _ref3.first;
          return sum + (first ? 0 : bytes);
        }, 0);
      }

      /**
       * @param {object} params
       * @param {number} params.unit chunk size in bytes
       * @param {number} interval params.interval size in millis
       * @returns {number|undefined} the average number of bytes transmitted
       * within the given interval
       */
    }, {
      key: "getBandwidth",
      value: function getBandwidth(_ref4) {
        var unit = _ref4.unit,
          interval = _ref4.interval;
        var chunks = this.$chunks;
        if (chunks.length <= 1) {
          return;
        }
        var measuredTime = chunks[chunks.length - 1].timestamp - chunks[0].timestamp;
        return this.getTotalBytes() / unit * (interval / measuredTime);
      }

      /**
       * @param {object} [params]
       * @param {string} [params.unit='MB'] the desired unit, one of B, KB, MB
       * @param {string} [params.interval='min'] the desired interval, one of sec,
       * min, hr
       * @returns {string} a display string, e.g. `500 KB/min`
       */
    }, {
      key: "getBandwidthDisplay",
      value: function getBandwidthDisplay() {
        var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref5$unit = _ref5.unit,
          unit = _ref5$unit === void 0 ? 'MB' : _ref5$unit,
          _ref5$interval = _ref5.interval,
          interval = _ref5$interval === void 0 ? 'min' : _ref5$interval;
        var bandwidth = this.getBandwidth({
          unit: unitToBytes(unit),
          interval: intervalToMs(interval)
        });
        return "".concat(roundToPlaces(bandwidth, 1), " ").concat(unit, "/").concat(interval);
      }
    }]);
  }();
  function unitToBytes(unit) {
    switch (unit) {
      case 'B':
        return 1;
      case 'KB':
        return 1024;
      case 'MB':
        return 1024 * 1024;
      default:
        throw new Error('unit must be one of B, KB, MB');
    }
  }
  function intervalToMs(interval) {
    switch (interval) {
      case 'sec':
        return 1000;
      case 'min':
        return 1000 * 60;
      case 'hr':
        return 1000 * 60 * 60;
      default:
        throw new Error('interval must be one of sec, min, hr');
    }
  }
  function roundToPlaces(num, places) {
    var pow = Math.pow(10, places);
    return Math.round(num * pow) / pow;
  }
});
