function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan 
 */

/*eslint-env browser */

/**
* API Status: **Private**
* @module  module:nmodule/videoDriver/rc/live/ZoomControl
*/
define(['baja!', 'baja!videoDriver:VideoZoomEnum', 'bajaux/commands/Command', 'jquery', 'underscore', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/webEditors/rc/fe/BaseWidget', 'log!nmodule.videoDriver.rc.live'], function (baja, types, Command, $, _, rpc, BaseWidget, log) {
  'use strict';

  var logInfo = log.info.bind(log);
  var DEFAULT_ZOOM_INTERVAL = 1000;
  var zoom = rpc.zoom;
  var tpl = function tpl(_ref) {
    var width = _ref.width,
      height = _ref.height;
    return "\n    <svg class=\"zoomSlider\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 ".concat(width, " ").concat(height, "\" preserveAspectRatio=\"none\"></svg>\n  ");
  };
  var getActionClass = function getActionClass(str) {
    var pattern = '\\bzoomIn\\b|\\bzoomOut\\b';
    var match = str.match(pattern);
    if (match) {
      return match[0];
    }
    return '';
  };
  var STAGE_HEIGHT = 100;
  var STAGE_WIDTH = 50;
  var getZoomInPoints = function getZoomInPoints() {
    var xCoords = [0, STAGE_WIDTH, STAGE_WIDTH, 0];
    var yCoords = [0, 0, STAGE_HEIGHT / 2, STAGE_HEIGHT / 2];
    return _.zip(xCoords, yCoords).map(function (coords) {
      return coords.join(',');
    }).join(' ');
  };
  var getZoomOutPoints = function getZoomOutPoints() {
    var xCoords = [0, STAGE_WIDTH, STAGE_WIDTH, 0];
    var yCoords = [STAGE_HEIGHT, STAGE_HEIGHT, STAGE_HEIGHT / 2, STAGE_HEIGHT / 2];
    return _.zip(xCoords, yCoords).map(function (coords) {
      return coords.join(',');
    }).join(' ');
  };

  /**
   * Zoom support to applicable cameras
   *  
   * @private
   * @class
   * @alias module:nmodule/videoDriver/rc/live/ZoomControl
   * @extends {module:nmodule/webEditors/rc/fe/BaseWidget}
   */
  var ZoomControl = /*#__PURE__*/function (_BaseWidget) {
    function ZoomControl() {
      _classCallCheck(this, ZoomControl);
      return _callSuper(this, ZoomControl, arguments);
    }
    _inherits(ZoomControl, _BaseWidget);
    return _createClass(ZoomControl, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.addClass('ZoomControl').html(tpl({
          height: STAGE_HEIGHT,
          width: STAGE_WIDTH
        }));
        this.$zoomCommands = this.$makeCommands();
        this.$init();
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('ZoomControl');
        if (this.$ticket) {
          clearTimeout(this.$ticket);
        }
      }
    }, {
      key: "getZoomCommands",
      value: function getZoomCommands() {
        return this.$zoomCommands;
      }
    }, {
      key: "$init",
      value: function $init() {
        var rootSvgEl = this.$getRootSvgJq()[0];
        rootSvgEl.appendChild(this.$makeMediumRegion());
        rootSvgEl.appendChild(this.$makeSlowRegion());
        rootSvgEl.appendChild(this.$makeZoomInRegion());
        rootSvgEl.appendChild(this.$makeZoomOutRegion());
        this.$armHandlers();
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getRootSvgJq",
      value: function $getRootSvgJq() {
        return this.jq().find('svg');
      }

      /**
       * @private
       * @returns {number}
       */
    }, {
      key: "$getZoomInterval",
      value: function $getZoomInterval() {
        return this.properties().getValue('zoomInterval') || DEFAULT_ZOOM_INTERVAL;
      }
    }, {
      key: "$armHandlers",
      value: function $armHandlers() {
        var _this = this;
        var direction,
          speed,
          lastX,
          lastY,
          lastZoomedDirection,
          svg = this.$getRootSvgJq();
        var getPageX = function getPageX(e) {
          if (e.touches && e.touches.length > 0) {
            return e.touches[0].pageX;
          } else {
            return e.pageX || e.clientX + $(window).scrollLeft();
          }
        };
        var getPageY = function getPageY(e) {
          if (e.touches && e.touches.length > 0) {
            return e.touches[0].pageY;
          } else {
            return e.pageY || e.clientY + $(window).scrollTop();
          }
        };
        var getDirection = function getDirection(e) {
          var pageX = getPageX(e);
          var pageY = getPageY(e);
          if (!isFinite(pageX)) {
            pageX = lastX;
          }
          if (!isFinite(pageY)) {
            pageY = lastY;
          }
          return document.elementFromPoint(pageX, pageY);
        };
        var resetRegions = function resetRegions() {
          svg.find('polygon').toggleClass('zHighlight', false);
          $(direction).toggleClass('zEnd', true);
        };
        var reset = function reset() {
          // Always follow with a 'none' on mouseup
          _this.$zoom(_this.$getVideoZoomAction('none'))["catch"](logInfo);
          resetTicket();
          resetRegions();
          // de-register the events
          svg.off();
          // rebind start
          svg.on('mousedown touchstart', zoomStart);
        };
        var resetTicket = function resetTicket() {
          if (_this.$ticket) {
            clearTimeout(_this.$ticket);
          }
        };

        /**
         * Convenience to get the rectangle slow/medium region beneath the polygon
         * 
         * @param {Event} e 
         */
        var getSpeed = function getSpeed(e) {
          return getDirection(e);
        };
        var inFastZone = function inFastZone(e) {
          // When the mouse is dragged only beyond the top and bottom of the zoom region
          var pageY = getPageY(e);
          var _this$jq$offset = _this.jq().offset(),
            top = _this$jq$offset.top;
          return pageY < top || pageY > _this.jq().height() + top;
        };
        var _zoom = function zoom() {
          if (lastZoomedDirection && lastZoomedDirection.nodeName === 'polygon') {
            var zoomAction = _this.$getZoomAction(speed.className.baseVal, getActionClass(lastZoomedDirection.className.baseVal));
            _this.$ticket = setTimeout(function () {
              return _zoom();
            }, _this.$getZoomInterval());
            throttled(zoomAction);
          }
        };
        var _zoomFast = function zoomFast() {
          if (lastZoomedDirection && lastZoomedDirection.nodeName === 'polygon') {
            var zoomAction = _this.$getZoomAction('fast', getActionClass(lastZoomedDirection.className.baseVal));
            _this.$ticket = setTimeout(function () {
              return _zoomFast();
            }, _this.$getZoomInterval());
            throttled(zoomAction);
          }
        };
        var throttled = baja.throttle(function (zoomAction) {
          return _this.$zoom(zoomAction)["catch"](logInfo);
        }, {
          interval: 500,
          drop: true
        });
        var zoomStart = function zoomStart(e) {
          // Arm mousemove
          svg.on('mousemove touchmove', function (e) {
            direction = getDirection(e);
            if (direction && direction.nodeName === 'polygon') {
              lastZoomedDirection = direction;
              resetRegions();
              $(direction).toggleClass('zHighlight', true);
              $(direction).toggleClass('zEnd', false);
              var polygonDisplay = direction.style.display;
              direction.style.display = 'none';
              speed = getSpeed(e);
              direction.style.display = polygonDisplay;
              resetTicket();
              return direction && speed && _zoom();
            } else {
              // A wandering touch event will get you here, just zoom fast in the last direction touched
              resetTicket();
              return _zoomFast();
            }
          });
          $(document).off('mouseup touchend', reset);
          $(document).one('mouseup touchend', reset);
          svg.on('mouseleave', function (e) {
            resetTicket();
            if (inFastZone(e)) {
              lastZoomedDirection && _zoomFast();
            } else {
              direction && speed && _zoom();
            }
          });
          return false;
        };
        svg.on('mousedown touchstart', zoomStart);
      }
    }, {
      key: "$getZoomAction",
      value: function $getZoomAction(speed, direction) {
        var zoomAction = this.$getVideoZoomAction('none');
        switch (speed) {
          case 'slow':
            {
              switch (direction) {
                case 'zoomIn':
                  {
                    zoomAction = this.$getVideoZoomAction('zoomInSlow');
                    break;
                  }
                case 'zoomOut':
                  {
                    zoomAction = this.$getVideoZoomAction('zoomOutSlow');
                    break;
                  }
              }
              break;
            }
          case 'medium':
            {
              switch (direction) {
                case 'zoomIn':
                  {
                    zoomAction = this.$getVideoZoomAction('zoomInMedium');
                    break;
                  }
                case 'zoomOut':
                  {
                    zoomAction = this.$getVideoZoomAction('zoomOutMedium');
                    break;
                  }
              }
              break;
            }
          case 'fast':
            {
              switch (direction) {
                case 'zoomIn':
                  {
                    zoomAction = this.$getVideoZoomAction('zoomInFast');
                    break;
                  }
                case 'zoomOut':
                  {
                    zoomAction = this.$getVideoZoomAction('zoomOutFast');
                    break;
                  }
              }
              break;
            }
        }
        return zoomAction;
      }
    }, {
      key: "$getVideoZoomAction",
      value: function $getVideoZoomAction(actionTag) {
        return baja.$('videoDriver:VideoZoomEnum', actionTag);
      }

      /**
       * @private
       * @param {baja.FrozenEnum} zoomAction a 'videoDriver:VideoZoomEnum' enum
       * @returns {Promise}
       */
    }, {
      key: "$zoom",
      value: function $zoom(zoomAction) {
        if (!this.isEnabled()) {
          return Promise.resolve();
        }
        return this.$zoomCommands.get(zoomAction.getTag()).invoke();
      }

      /**
       * Make all the zoom commands
       * 
       * @private
       * @returns {baja.OrderedMap} map of zoom commands
       */
    }, {
      key: "$makeCommands",
      value: function $makeCommands() {
        var _this2 = this;
        var zoomRange = baja.$('videoDriver:VideoZoomEnum').getRange();
        var commandsMap = new baja.OrderedMap();
        zoomRange.getOrdinals().forEach(function (ordinal) {
          var zEnum = zoomRange.get(ordinal);
          var cmd = new Command({
            displayName: zEnum.getDisplayTag(),
            func: function func() {
              return zoom(_this2.value().getNavOrd(), zEnum.getTag());
            }
          });
          commandsMap.put(zEnum.getTag(ordinal), cmd);
        });
        return commandsMap;
      }
    }, {
      key: "$makeMediumRegion",
      value: function $makeMediumRegion() {
        var rect = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
        rect.setAttribute('x', 0);
        rect.setAttribute('y', 0);
        rect.setAttribute('width', STAGE_WIDTH);
        rect.setAttribute('height', STAGE_HEIGHT);
        rect.setAttribute('class', 'medium');
        return rect;
      }
    }, {
      key: "$makeSlowRegion",
      value: function $makeSlowRegion() {
        var rect = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
        var width = STAGE_WIDTH;
        var height = STAGE_HEIGHT * 0.65;
        rect.setAttribute('x', STAGE_WIDTH / 2 - width / 2);
        rect.setAttribute('y', STAGE_HEIGHT / 2 - height / 2);
        rect.setAttribute('width', width);
        rect.setAttribute('height', height);
        rect.setAttribute('class', 'slow');
        return rect;
      }
    }, {
      key: "$makeZoomOutRegion",
      value: function $makeZoomOutRegion() {
        var points = getZoomOutPoints();
        var polygon = document.createElementNS('http://www.w3.org/2000/svg', 'polygon');
        polygon.setAttribute('points', points);
        polygon.setAttribute('class', 'zoomOut');
        return polygon;
      }
    }, {
      key: "$makeZoomInRegion",
      value: function $makeZoomInRegion() {
        var points = getZoomInPoints();
        var polygon = document.createElementNS('http://www.w3.org/2000/svg', 'polygon');
        polygon.setAttribute('points', points);
        polygon.setAttribute('class', 'zoomIn');
        return polygon;
      }
    }]);
  }(BaseWidget);
  return ZoomControl;
});
