function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module module:nmodule/videoDriver/rc/live/LiveVideo
 */
define(['baja!', 'log!nmodule.videoDriver.rc.live', 'bajaux/Properties', 'bajaux/Widget', 'bajaux/mixin/responsiveMixIn', 'bajaux/mixin/subscriberMixIn', 'jquery', 'Promise', 'underscore', 'nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin', 'nmodule/videoDriver/rc/live/stream/StreamSettings', 'nmodule/videoDriver/rc/live/stream/StreamSettingsCommand', 'nmodule/videoDriver/rc/live/stream/StreamSettingsWidget', 'nmodule/videoDriver/rc/fe/utils/CameraPresetsWidget', 'nmodule/videoDriver/rc/fe/utils/FocusControlPane', 'nmodule/videoDriver/rc/fe/utils/IrisControlPane', 'nmodule/videoDriver/rc/fe/utils/videoDriverUtils', 'nmodule/videoDriver/rc/live/PanTiltControl', 'nmodule/videoDriver/rc/live/VideoFeedMixin', 'nmodule/videoDriver/rc/live/VideoTimestampWidget', 'nmodule/videoDriver/rc/live/VideoStatusWidget', 'nmodule/videoDriver/rc/live/ZoomControl', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'baja!videoDriver:VideoMultistreamAspectRatioEnum'], function (baja, log, Properties, Widget, responsiveMixIn, subscriberMixIn, $, Promise, _, StreamConfigurationMixin, StreamSettings, StreamSettingsCommand, StreamSettingsWidget, CameraPresetsWidget, FocusControlPane, IrisControlPane, videoDriverUtils, PanTiltControl, VideoFeedMixin, VideoTimestampWidget, VideoStatusWidget, ZoomControl, rpc, fe, feDialogs, BaseEditor, DisplayOnlyEditor) {
  "use strict";

  var tpl = function tpl() {
    return "    \n    <div class=\"CameraPresetsWidget\"></div>\n    <div class=\"videoContainer\">\n      <div class=\"feedContainer\">\n        <div class='videoStream'></div>\n        <div class='PanTiltControl'></div>  \n        <div class='ZoomControl'></div>  \n        <div class='timestamp'></div>\n        <div class='cameraControlsContainer'>\n          <div class='irisControl'></div>\n          <div class='focusControl'></div>\n        </div>\n      </div>\n      <div class='status'></div>\n    </div>\n  ";
  };
  var isFunction = _.isFunction;
  var STREAM_DATA_RECEIVED_EVENT = VideoFeedMixin.STREAM_DATA_RECEIVED_EVENT;
  var fitRatio = videoDriverUtils.fitRatio,
    getNoStreamMessage = videoDriverUtils.getNoStreamMessage;
  var logInfo = log.info.bind(log);
  var logSevere = log.severe.bind(log);
  var SHOW_CAMERA_CONTROLS_INTERVAL = 3000;
  var PLAYBACK_TYPE = 'playbackType';
  var PLAYBACK_TIMESTAMP = 'playbackTimestamp';
  var SHOW_PTZ_PRESETS = 'showPtzAndPresets';
  var ASPECT_RATIO = 'aspectRatio';

  /**
   * Baja Widget for picking the right VideoStream and streaming it. It supports
   * the following bajaux Properties:
   *
   * - `playbackType`: a String corresponding to a `BPlaybackTypeEnum` tag.
   *   Specifies how the video should be playing. Defaults to `live`
   * - `playbackTimestamp`: a String encoding of a `baja:AbsTime` that indicates
   *   when the playback should start. Will only be respected if `playbackType`
   *   is `play`. Defaults to `AbsTime.DEFAULT`, which also indicates that
   *   the playback should start "now" instead of a specified time.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/gx/rc/fe/LiveVideo
   */
  var LiveVideo = /*#__PURE__*/function (_BaseEditor) {
    function LiveVideo(params) {
      var _this;
      _classCallCheck(this, LiveVideo);
      _this = _callSuper(this, LiveVideo, [_.extend({
        keyName: 'LiveVideo',
        moduleName: 'videoDriver'
      }, params, {
        properties: Properties.extend(_defineProperty(_defineProperty(_defineProperty(_defineProperty({}, PLAYBACK_TYPE, {
          value: 'live',
          typeSpec: 'videoDriver:PlaybackTypeEnum'
        }), PLAYBACK_TIMESTAMP, {
          value: baja.AbsTime.DEFAULT.encodeToString(),
          typeSpec: 'baja:AbsTime'
        }), SHOW_PTZ_PRESETS, {
          value: true,
          typeSpec: 'baja:Boolean'
        }), ASPECT_RATIO, {
          value: baja.$('videoDriver:VideoMultistreamAspectRatioEnum', 'inherit_from_camera'),
          typeSpec: 'videoDriver:VideoMultistreamAspectRatioEnum'
        }), params && params.properties)
      })]);
      subscriberMixIn(_this);
      responsiveMixIn(_this, {
        'LiveVideoSmall': {
          maxWidth: 200
        },
        'LiveVideoMedium': {
          minWidth: 200,
          maxWidth: 400
        },
        'LiveVideoLarge': {
          minWidth: 400
        }
      });
      _this.getCommandGroup().add(new StreamSettingsCommand(_this));
      return _this;
    }

    /**
     * @private
     * @returns {module:nmodule/videoDriver/rc/live/stream/StreamSettingsCommand}
     */
    _inherits(LiveVideo, _BaseEditor);
    return _createClass(LiveVideo, [{
      key: "$getStreamSettingsCommand",
      value: function $getStreamSettingsCommand() {
        return this.getCommandGroup().get(0);
      }

      /**
       * Creates an editor with correctly labeled width and height editors.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.html(tpl()).addClass('LiveVideo');
        dom.on('mousemove mousedown', '.videoStream, .PanTiltControl', function () {
          return _this2.$showCameraControls();
        });
        dom.on('mousedown', function () {
          _this2.$mousedown = true;
          $(document).one('mouseup', function () {
            _this2.$mousedown = false;
          });
        });
        this.$currentPlaybackType = this.$getPlaybackType();
        return Promise.all([new PanTiltControl().initialize(this.$getPanTiltControlElement()), new ZoomControl().initialize(this.$getZoomControlElement()), new FocusControlPane().initialize(this.$getFocusControlElement()), new IrisControlPane().initialize(this.$getIrisControlElement()), new CameraPresetsWidget().initialize(this.$getCameraPresetsElement()), new VideoTimestampWidget().initialize(this.$getCameraTimestampElement()), new VideoStatusWidget().initialize(this.$getCameraStatusElement())]);
      }

      /**
       * Find the best `videoDriver:IVideoStream` based on the value passed in.
       * @param {baja.Component} value
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this3 = this;
        var camera = value;
        videoDriverUtils.removeVideoEventListeners(this.$getVideoStream());
        return videoDriverUtils.resolveCamera(value).then(function (resolvedCamera) {
          if (resolvedCamera) {
            camera = resolvedCamera;
            return videoDriverUtils.getVideoStreamAgent(camera);
          }
        }).then(function (videoStreamType) {
          if (!videoStreamType) {
            return _this3.$showNoStreamError(camera);
          }
          logInfo("streamer: " + videoStreamType.name);

          //rpc must be done before axis web socket call or connection failure can cause bajascript to pause
          return rpc.getCameraInfo(camera.getNavOrd()).then(function (cameraInfo) {
            var focusEnabled = cameraInfo.focusEnabled,
              irisEnabled = cameraInfo.irisEnabled,
              panTiltEnabled = cameraInfo.panTiltEnabled,
              zoomEnabled = cameraInfo.zoomEnabled,
              focusInterval = cameraInfo.focusInterval,
              irisInterval = cameraInfo.irisInterval,
              moveInterval = cameraInfo.moveInterval,
              zoomInterval = cameraInfo.zoomInterval;
            _this3.jq().toggleClass('zoomEnabled', zoomEnabled);
            _this3.$showPtzAndPresets = _this3.properties().getValue(SHOW_PTZ_PRESETS);
            _this3.$panTiltEnabled = panTiltEnabled;
            _this3.$zoomEnabled = zoomEnabled;
            _this3.$focusEnabled = focusEnabled;
            _this3.$irisEnabled = irisEnabled;
            var timestamp = _this3.properties().getValue(PLAYBACK_TIMESTAMP);
            var focusControlPane = _this3.$getFocusControlPane();
            var irisControlPane = _this3.$getIrisControlPane();
            var panTiltControl = _this3.$getPanTiltControl();
            var zoomControl = _this3.$getZoomControl();
            return Promise.all([fe.buildFor({
              formFactor: 'mini',
              dom: _this3.$getVideoStreamElement(),
              type: videoStreamType,
              value: camera,
              properties: _defineProperty({}, PLAYBACK_TIMESTAMP, timestamp)
            }), focusControlPane.properties().add('focusInterval', focusInterval), focusControlPane.load(camera), irisControlPane.properties().add('irisInterval', irisInterval), irisControlPane.load(camera), panTiltControl.properties().add('moveInterval', moveInterval), panTiltControl.load(camera), zoomControl.properties().add('zoomInterval', zoomInterval), zoomControl.load(camera), _this3.$getCameraPresetsWidget().load(camera)]).then(function () {
              var videoStream = _this3.$getVideoStream();
              if (typeof videoStream.on === 'function') {
                // don't consider zoom enabled until we get first stream data
                var _zoomEnabled = _this3.$zoomEnabled;
                _this3.$zoomEnabled = false;
                videoStream.once(STREAM_DATA_RECEIVED_EVENT, function () {
                  _this3.$zoomEnabled = _zoomEnabled;
                  _this3.$updateVideoControls()["catch"](logSevere);
                  _this3.layout()["catch"](logSevere);
                });
                videoStream.on('videoDriver:playback', function (_ref) {
                  var type = _ref.type;
                  // Disable live video controls if playback type is not "live"
                  _this3.$currentPlaybackType = type;
                  _this3.$updateVideoControls()["catch"](logSevere);
                });
              }
              videoDriverUtils.initializeVideoEventListeners(videoStream);
              return Promise.all([_this3.$getCameraStatusWidget().load(videoStream), _this3.$applyStreamSettings(videoStream), cameraInfo.isTimestampPreferred && _this3.$getCameraTimestampWidget().load(videoStream)]);
            });
          }).then(function () {
            //loading can cause the aspect ratio to change
            fixVideoToContainer(_this3.$getVideoElement(), _this3.properties().getValue(ASPECT_RATIO));
            return _this3.$updatePlayback();
          })["catch"](function (err) {
            baja.error(err);
            _this3.$getStreamSettingsCommand().setEnabled(false);
            return _this3.$showError(err);
          });
        });
      }
    }, {
      key: "getResponsiveMediaInfo",
      value: function getResponsiveMediaInfo() {
        var container = this.jq();
        if (container.length) {
          return {
            width: Math.floor(container.innerWidth() || 0),
            height: Math.floor(container.innerHeight() || 0)
          };
        } else {
          var w = $(window);
          return {
            width: w.width(),
            height: w.height()
          };
        }
      }
    }, {
      key: "doReadonly",
      value:
      /**
       * Sets all the child widgets of this editor to readonly.
       *
       * @param {boolean} readonly
       * @returns {Promise}
       */
      function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }

      /**
       * Sets all the child widgets of this editor to enabled.
       *
       * @param {boolean} enabled
       * @returns {Promise}
       */
    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        var _this4 = this;
        return this.getChildWidgets().layoutAll().then(function () {
          fixVideoToContainer(_this4.$getVideoElement(), _this4.properties().getValue(ASPECT_RATIO));
        });
      }

      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        videoDriverUtils.removeVideoEventListeners(this.$getVideoStream());
        var jq = this.jq();
        jq.removeClass('LiveVideo LiveVideoSmall LiveVideoMedium LiveVideoLarge');
        jq.css('max-width', '');
        clearTimeout(this.$cameraControlsTicket);
        return this.getChildWidgets().destroyAll();
      }

      /**
       * @private
       * @param {module:bajaux/Widget} videoStream
       * @returns {Promise}
       */
    }, {
      key: "$applyStreamSettings",
      value: function $applyStreamSettings(videoStream) {
        var _this5 = this;
        var supportsStreamSettings = StreamConfigurationMixin.isOn(videoStream);
        this.$getStreamSettingsCommand().setEnabled(supportsStreamSettings);
        if (!supportsStreamSettings) {
          return Promise.resolve();
        }
        return StreamSettings.make(videoStream).then(function (settings) {
          Object.keys(settings).forEach(function (k) {
            var prop = _this5.properties().getValue(k);
            if (prop) {
              settings[k] = prop;
            }
          });
          return videoStream.applyStreamSettings(settings);
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$updatePlayback",
      value: function $updatePlayback() {
        var videoStream = this.$getVideoStream();
        if (videoStream && isFunction(videoStream.playback)) {
          var timestamp = this.$getPlaybackTimestamp();
          var params = {
            type: this.$getPlaybackType(),
            speed: 1
          };
          if (timestamp) {
            params.timestamp = timestamp;
          }
          return Promise.resolve(this.$getVideoStream().playback(params));
        } else {
          return Promise.resolve();
        }
      }

      /**
       * @private
       * @returns {string}
       */
    }, {
      key: "$getPlaybackType",
      value: function $getPlaybackType() {
        return this.properties().getValue(PLAYBACK_TYPE);
      }

      /**
       * @private
       * @returns {number} the timestamp the widget is user-configured to start
       * playback from
       */
    }, {
      key: "$getPlaybackTimestamp",
      value: function $getPlaybackTimestamp() {
        var str = this.properties().getValue(PLAYBACK_TIMESTAMP);
        if (str) {
          return baja.AbsTime.DEFAULT.decodeFromString(str).getMillis();
        }
        return 0;
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getVideoStreamElement",
      value: function $getVideoStreamElement() {
        return this.jq().find('.videoStream');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getCameraControlsContainerElement",
      value: function $getCameraControlsContainerElement() {
        return this.jq().find('.cameraControlsContainer');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getFocusControlElement",
      value: function $getFocusControlElement() {
        return this.jq().find('.focusControl');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getIrisControlElement",
      value: function $getIrisControlElement() {
        return this.jq().find('.irisControl');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getPanTiltControlElement",
      value: function $getPanTiltControlElement() {
        return this.jq().find('.PanTiltControl');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getZoomControlElement",
      value: function $getZoomControlElement() {
        return this.jq().find('.ZoomControl');
      }

      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/utils/FocusControlPane}
       */
    }, {
      key: "$getFocusControlPane",
      value: function $getFocusControlPane() {
        // noinspection JSValidateTypes
        return Widget["in"](this.$getFocusControlElement());
      }

      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/utils/IrisControlPane}
       */
    }, {
      key: "$getIrisControlPane",
      value: function $getIrisControlPane() {
        // noinspection JSValidateTypes
        return Widget["in"](this.$getIrisControlElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getCameraPresetsElement",
      value: function $getCameraPresetsElement() {
        return this.jq().find('.CameraPresetsWidget');
      }

      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/live/VideoTimestampWidget}
       */
    }, {
      key: "$getCameraTimestampWidget",
      value: function $getCameraTimestampWidget() {
        // noinspection JSValidateTypes
        return Widget["in"](this.$getCameraTimestampElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getCameraTimestampElement",
      value: function $getCameraTimestampElement() {
        return this.jq().find('.timestamp');
      }

      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/live/VideoStatusWidget}
       */
    }, {
      key: "$getCameraStatusWidget",
      value: function $getCameraStatusWidget() {
        // noinspection JSValidateTypes
        return Widget["in"](this.$getCameraStatusElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getCameraStatusElement",
      value: function $getCameraStatusElement() {
        return this.jq().find('.status');
      }

      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/live/PanTiltControl}
       */
    }, {
      key: "$getPanTiltControl",
      value: function $getPanTiltControl() {
        // noinspection JSValidateTypes
        return Widget["in"](this.$getPanTiltControlElement());
      }

      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/live/ZoomControl}
       */
    }, {
      key: "$getZoomControl",
      value: function $getZoomControl() {
        // noinspection JSValidateTypes
        return Widget["in"](this.$getZoomControlElement());
      }

      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/utils/CameraPresetsWidget}
       */
    }, {
      key: "$getCameraPresetsWidget",
      value: function $getCameraPresetsWidget() {
        // noinspection JSValidateTypes
        return Widget["in"](this.$getCameraPresetsElement());
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getVideoStream",
      value: function $getVideoStream() {
        return Widget["in"](this.$getVideoStreamElement());
      }

      /**
       * @private
       * @returns {JQuery} the actual `video` or `canvas` element that's painting
       * the video feed
       */
    }, {
      key: "$getVideoElement",
      value: function $getVideoElement() {
        return this.jq().find('.videoStream .videoInsert');
      }

      /**
       * @private
       */
    }, {
      key: "$showCameraControls",
      value: function $showCameraControls() {
        var _this6 = this;
        this.$getCameraControlsContainerElement().addClass('cameraControlsActive');
        clearTimeout(this.$cameraControlsTicket);
        this.$cameraControlsTicket = setTimeout(function () {
          if (_this6.$mousedown) {
            _this6.$showCameraControls();
          } else {
            _this6.$hideCameraControls();
          }
        }, SHOW_CAMERA_CONTROLS_INTERVAL);
      }

      /**
       * @private
       * @param {baja.Component} camera
       * @returns {Promise}
       */
    }, {
      key: "$showNoStreamError",
      value: function $showNoStreamError(camera) {
        return fe.buildFor({
          formFactor: 'mini',
          dom: this.$getVideoStreamElement(),
          type: DisplayOnlyEditor,
          value: getNoStreamMessage(camera)
        });
      }

      /**
       * @private
       * @param {baja.Component} err
       * @returns {Promise}
       */
    }, {
      key: "$showError",
      value: function $showError(err) {
        return fe.buildFor({
          formFactor: 'mini',
          dom: this.$getVideoStreamElement(),
          type: DisplayOnlyEditor,
          value: err
        });
      }

      /**
       * @private
       */
    }, {
      key: "$hideCameraControls",
      value: function $hideCameraControls() {
        this.$getCameraControlsContainerElement().removeClass('cameraControlsActive');
      }

      /**
       * Enabled disable live video controls like pan/tilt, zoom, focus and iris
       * based on the playback type
       * 
       * @returns {Promise}
       */
    }, {
      key: "$updateVideoControls",
      value: function $updateVideoControls() {
        var isLive = this.$currentPlaybackType === 'live';
        return Promise.all([this.$getPanTiltControl().setEnabled(this.$panTiltEnabled && isLive && this.$showPtzAndPresets), this.$getFocusControlPane().setEnabled(this.$focusEnabled && isLive && this.$showPtzAndPresets), this.$getIrisControlPane().setEnabled(this.$irisEnabled && isLive && this.$showPtzAndPresets), this.$getZoomControl().setEnabled(this.$zoomEnabled && isLive && this.$showPtzAndPresets), this.$getCameraPresetsWidget().setEnabled(this.$showPtzAndPresets)]);
      }
    }]);
  }(BaseEditor);
  function tagToString(tag) {
    if (baja.hasType(tag, 'baja:Enum')) {
      tag = tag.getTag();
    }
    return String(tag);
  }
  function fixVideoToContainer(video, aspectRatio) {
    var container = video.closest('.videoContainer');
    if (!container.length) {
      return;
    }
    var el = video[0];
    if (tagToString(aspectRatio) === 'fit_to_screen') {
      aspectRatio = container.width() / container.height();
    }
    if (tagToString(aspectRatio) === 'inherit_from_camera') {
      switch (el.tagName.toLowerCase()) {
        case 'video':
          aspectRatio = el.videoWidth / el.videoHeight;
          break;
        case 'canvas':
          aspectRatio = el.width / el.height;
          break;
        default:
          logSevere('cannot size element ' + el.tagName);
          return;
      }
    }
    video.hide();
    var _fitRatio = fitRatio(aspectRatio, {
        width: container.width(),
        height: container.height()
      }),
      width = _fitRatio.width,
      height = _fitRatio.height;
    video.width(width);
    video.height(height);
    video.show();
  }
  return LiveVideo;
});
