function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/playback/PlaybackControlsWidget
 */
define(['baja!', 'lex!videoDriver', 'bajaux/Properties', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/commands/ToggleCommandGroup', 'bajaux/util/CommandButtonGroup', 'Promise', 'underscore', 'nmodule/videoDriver/rc/fe/playback/PlaybackMixin', 'nmodule/videoDriver/rc/fe/playback/VideoEventChooser', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, lexs, Properties, Widget, Command, CommandGroup, ToggleCommandGroup, CommandButtonGroup, Promise, _, PlaybackMixin, VideoEventChooser, BaseWidget, fe, feDialogs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    videoDriverLex = _lexs[0];
  var MAX_PLAYBACK_SPEED = 10;
  var tpl = function tpl() {
    return "\n    <span class=\"playbackCommands\"></span>\n    <span class=\"selectionCommands\"></span>\n    <span class=\"speedIndicator\"></span> \n  ";
  };

  /**
   * Widget for controlling playback on a camera that supports it. Handles
   * rewind/fast-forward, play/pause, live mode, and seeking to a specific
   * moment in time.
   *
   * In order to load a video controller, it must have `PlaybackMixin` applied.
   *
   * It supports the following bajaux Properties:
   *
   * - `playbackType`: a String that indicates what playback mode the widget
   *   should start in. Defaults to `live`.
   *
   * @class
   * @alias module:nmodule/videoDriver/rc/fe/playback/PlaybackControlsWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @see module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin
   */
  return /*#__PURE__*/function (_BaseWidget) {
    function PlaybackControlsWidget(params) {
      var _this;
      _classCallCheck(this, PlaybackControlsWidget);
      _this = _callSuper(this, PlaybackControlsWidget, [_.extend({
        moduleName: 'videoDriver',
        keyName: 'PlaybackControlsWidget'
      }, params, {
        properties: Properties.extend({
          playbackType: {
            value: 'live',
            typeSpec: 'videoDriver:PlaybackTypeEnum'
          }
        }, params && params.properties)
      })]);
      var cmd = function cmd(lex, func) {
        return new Command({
          module: 'videoDriver',
          lex: lex,
          func: func
        });
      };
      var toggleCmd = function toggleCmd(lex, value) {
        return {
          module: 'videoDriver',
          lex: lex,
          value: value
        };
      };
      var playbackCommands = new ToggleCommandGroup({
        onChange: function onChange(methodName, arg) {
          if (methodName === 'play' && arg) {
            _this.$setNonLiveCommandsEnabled(true);
            return _this.$playback({
              type: 'play',
              timestamp: arg
            });
          }
          return _this[methodName]();
        },
        commands: [toggleCmd('videoPlaybackControls.rwd', 'rewind'), toggleCmd('videoPlaybackControls.ffwd', 'fastForward'), toggleCmd('videoPlaybackControls.srwd', 'slowRewind'), toggleCmd('videoPlaybackControls.sfwd', 'slowForward'), toggleCmd('videoPlaybackControls.play', 'play'), toggleCmd('videoPlaybackControls.pause', 'pause'), toggleCmd('videoPlaybackControls.live', 'live')]
      });
      var selectionCommands = new CommandGroup({
        commands: [cmd('VideoEventChooser', function () {
          return _this.browseEvents();
        }), cmd('VideoPlaybackView.PlayFromTimeIndex', function () {
          return _this.chooseTimeIndex();
        })]
      });
      _this.$playbackCommands = playbackCommands;
      _this.$selectionCommands = selectionCommands;
      var commandGroup = _this.getCommandGroup();
      commandGroup.add.apply(commandGroup, playbackCommands.getChildren());
      commandGroup.add.apply(commandGroup, selectionCommands.getChildren());
      return _this;
    }

    /**
     * @private
     * @returns {module:bajaux/commands/Command}
     */
    _inherits(PlaybackControlsWidget, _BaseWidget);
    return _createClass(PlaybackControlsWidget, [{
      key: "$getRewindCommand",
      value: function $getRewindCommand() {
        return this.getCommandGroup().get(0);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getFastForwardCommand",
      value: function $getFastForwardCommand() {
        return this.getCommandGroup().get(1);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getSlowRewindCommand",
      value: function $getSlowRewindCommand() {
        return this.getCommandGroup().get(2);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getSlowForwardCommand",
      value: function $getSlowForwardCommand() {
        return this.getCommandGroup().get(3);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getPlayCommand",
      value: function $getPlayCommand() {
        return this.getCommandGroup().get(4);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getPauseCommand",
      value: function $getPauseCommand() {
        return this.getCommandGroup().get(5);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getLiveCommand",
      value: function $getLiveCommand() {
        return this.getCommandGroup().get(6);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getBrowseEventsCommand",
      value: function $getBrowseEventsCommand() {
        return this.getCommandGroup().get(7);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getFindEventsCommand",
      value: function $getFindEventsCommand() {
        return this.getCommandGroup().get(8);
      }

      /**
       * Build button groups for all playback commands.
       *
       * @param {JQuery} dom
       */
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl()).addClass('PlaybackControlsWidget');
        return Promise.all([fe.buildFor({
          dom: this.$getPlaybackCommandsElement(),
          value: this.$playbackCommands,
          type: CommandButtonGroup,
          properties: {
            toolbar: true
          },
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getSelectionCommandsElement(),
          value: this.$selectionCommands,
          type: CommandButtonGroup,
          properties: {
            toolbar: true
          },
          formFactor: 'mini'
        })]);
      }

      /**
       * Starts out the controller in live mode on first load.
       *
       * @param {module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin} controller
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(controller) {
        var _this2 = this;
        if (typeof controller.playback !== 'function') {
          throw new Error('controller with PlaybackMixin required');
        }
        controller.on(PlaybackMixin.PLAYBACK_CHANGED_EVENT, function (_ref) {
          var type = _ref.type,
            speed = _ref.speed;
          _this2.$updateButtonStatusFromPlayback(type);
          _this2.$updateSpeedIndicator(speed);
        });
        this.$updateButtonStatusFromPlayback(this.properties().getValue('playbackType'));
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('PlaybackControlsWidget');
        return this.getChildWidgets().destroyAll();
      }
    }, {
      key: "rewind",
      value:
      /**
       * Starts rewind playback. Rewinds faster and faster on subsequent calls.
       * @returns {Promise}
       */
      function rewind() {
        return this.$playback({
          type: 'fastRew',
          speed: this.$incrementSpeed('fastRew')
        });
      }

      /**
       * Starts fast-forward playback. Fast-forwards faster and faster on
       * subsequent calls.
       * @returns {Promise}
       */
    }, {
      key: "fastForward",
      value: function fastForward() {
        return this.$playback({
          type: 'fastFwd',
          speed: this.$incrementSpeed('fastFwd')
        });
      }

      /**
       * Starts slow-rewind playback. Slow-rewinds slower and slower on subsequent
       * calls.
       * @returns {Promise}
       */
    }, {
      key: "slowRewind",
      value: function slowRewind() {
        return this.$playback({
          type: 'slowRew',
          speed: this.$incrementSpeed('slowRew')
        });
      }

      /**
       * Starts slow-forward playback. Slow-forwards slower and slower on
       * subsequent calls.
       * @returns {Promise}
       */
    }, {
      key: "slowForward",
      value: function slowForward() {
        return this.$playback({
          type: 'slowFwd',
          speed: this.$incrementSpeed('slowFwd')
        });
      }

      /**
       * Starts normal playback.
       * @returns {Promise}
       */
    }, {
      key: "play",
      value: function play() {
        this.$speed = 0;
        return this.$playback({
          type: 'play'
        });
      }

      /**
       * Plays from a moment in time.
       * @param {baja.AbsTime|Date} timeIndex
       * @returns {Promise}
       */
    }, {
      key: "playFrom",
      value: function playFrom(timeIndex) {
        return this.$getPlayCommand().invoke(+timeIndex);
      }

      /**
       * Pauses playback.
       * @returns {Promise}
       */
    }, {
      key: "pause",
      value: function pause() {
        this.$speed = 0;
        return this.$playback({
          type: 'pause'
        });
      }

      /**
       * Starts live camera view.
       * @returns {Promise}
       */
    }, {
      key: "live",
      value: function live() {
        this.$speed = 0;
        return this.$playback({
          type: 'live'
        });
      }

      /**
       * Allows the user to browse a list of events from the current camera, and
       * then starts playback from the selected event.
       * @returns {Promise}
       */
    }, {
      key: "browseEvents",
      value: function browseEvents() {
        var _this3 = this;
        return feDialogs.showFor({
          title: videoDriverLex.get('VideoPlaybackView.BrowseEventsCommand.label'),
          type: VideoEventChooser,
          value: baja.AbsTime.now(),
          properties: {
            cameraOrd: this.value().getCamera().getNavOrd()
          }
        }).then(function (result) {
          return result && _this3.playFrom(result);
        });
      }

      /**
       * Allows the user to choose a specific time, and then starts playback from
       * that time.
       * @returns {Promise}
       */
    }, {
      key: "chooseTimeIndex",
      value: function chooseTimeIndex() {
        var _this4 = this;
        return feDialogs.showFor({
          title: videoDriverLex.get('VideoPlaybackView.PlayFromTimeIndex.title'),
          value: this.$getLastAbsTime(),
          formFactor: 'mini'
        }).then(function (result) {
          return result && _this4.playFrom(result);
        });
      }

      /**
       * Convert the lastTimestamp to an AbsTime if its available.
       * Use `baja.AbsTime.now()` if it cannot be found.
       * @return {baja.AbsTime}
       */
    }, {
      key: "$getLastAbsTime",
      value: function $getLastAbsTime() {
        var date = this.value() && this.value().getCurrentTimestamp && this.value().getCurrentTimestamp();
        if (date) {
          return baja.AbsTime.make({
            jsDate: date
          });
        } else {
          return baja.AbsTime.now();
        }
      }

      /**
       * Set all playback buttons' enabled/selected status as appropriate for the
       * current playback type.
       * @private
       * @param {string} playbackType
       */
    }, {
      key: "$updateButtonStatusFromPlayback",
      value: function $updateButtonStatusFromPlayback(playbackType) {
        var enabledCommand = this.$getCommandForPlaybackType(playbackType);
        this.$playbackCommands.getChildren().forEach(function (cmd) {
          cmd.setSelected(cmd === enabledCommand);
        });
        this.$setNonLiveCommandsEnabled(playbackType !== 'live');
      }

      /**
       * Set the speed text if it is greater than 1, otherwise no speed will be displayed.
       * @private
       * @param {Number} speed
       */
    }, {
      key: "$updateSpeedIndicator",
      value: function $updateSpeedIndicator(speed) {
        var dom = this.$getSpeedIndicatorElement();
        if (speed > 1) {
          dom.text(videoDriverLex.get('speedIndicator.display', speed));
          dom.attr('title', videoDriverLex.get('speedIndicator.description'));
        } else {
          dom.text('');
          dom.attr('title', '');
        }
      }

      /**
       * @private
       * @param {String} playbackType
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getCommandForPlaybackType",
      value: function $getCommandForPlaybackType(playbackType) {
        switch (playbackType) {
          case 'play':
            return this.$getPlayCommand();
          case 'pause':
            return this.$getPauseCommand();
          case 'slowFwd':
            return this.$getSlowForwardCommand();
          case 'slowRew':
            return this.$getSlowRewindCommand();
          case 'fastFwd':
            return this.$getFastForwardCommand();
          case 'fastRew':
            return this.$getRewindCommand();
          case 'live':
          default:
            return this.$getLiveCommand();
        }
      }

      /**
       * Send the playback information unless the Widget is currently loading.
       * @private
       * @param {object} params
       * @returns {Promise}
       */
    }, {
      key: "$playback",
      value: function $playback(params) {
        var _this5 = this;
        if (this.isLoading()) {
          return Promise.resolve();
        }
        var controller = this.value();
        return Promise.resolve(controller.playback(params)).then(function () {
          return _this5.$updateButtonStatusFromPlayback(params.type);
        });
      }

      /**
       * @private
       * @param {string} playbackType
       * @returns {number}
       */
    }, {
      key: "$incrementSpeed",
      value: function $incrementSpeed(playbackType) {
        var speed = this.$type === playbackType ? this.$speed + 1 : 1;
        this.$type = playbackType;
        return this.$speed = Math.min(speed, MAX_PLAYBACK_SPEED);
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getPlaybackCommandsElement",
      value: function $getPlaybackCommandsElement() {
        return this.jq().children('.playbackCommands');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup}
       */
    }, {
      key: "$getPlaybackCommandButtonGroup",
      value: function $getPlaybackCommandButtonGroup() {
        return Widget["in"](this.$getPlaybackCommandsElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getSelectionCommandsElement",
      value: function $getSelectionCommandsElement() {
        return this.jq().children('.selectionCommands');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup}
       */
    }, {
      key: "$getSelectionCommandButtonGroup",
      value: function $getSelectionCommandButtonGroup() {
        return Widget["in"](this.$getSelectionCommandsElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getSpeedIndicatorElement",
      value: function $getSpeedIndicatorElement() {
        return this.jq().children('.speedIndicator');
      }

      /**
       * @private
       * @returns {Array.<module:bajaux/commands/Command>} commands that do not
       * function in Live mode
       */
    }, {
      key: "$getNonLiveCommands",
      value: function $getNonLiveCommands() {
        return [this.$getFastForwardCommand(), this.$getSlowForwardCommand(), this.$getPlayCommand()];
      }

      /**
       * @private
       * @param {boolean} enabled
       */
    }, {
      key: "$setNonLiveCommandsEnabled",
      value: function $setNonLiveCommandsEnabled(enabled) {
        this.$getNonLiveCommands().forEach(function (cmd) {
          return cmd.setEnabled(enabled);
        });
      }
    }]);
  }(BaseWidget);
});
