function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/entsecHx/rc/photoID/PhotoIDsUxView
 */
define(['baja!', 'bajaux/Widget', 'bajaux/events', 'bajaux/mixin/subscriberMixIn', 'jquery', 'Promise', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/servlets/userData', 'nmodule/entsecHx/rc/photoID/PhotoIdViewerListWidget', 'nmodule/entsecHx/rc/photoID/PhotoIdViewerOptionsWidget', 'nmodule/entsecHx/rc/photoID/ButtonsPane', 'nmodule/entsecHx/rc/photoID/PhotoIdViewerGrid', 'nmodule/entsecHx/rc/photoID/rpc/rpc', 'lex!entsecHx', 'css!nmodule/entsecHx/rc/entsecHx'], function (baja, Widget, events, subscriberMixIn, $, Promise, Command, BaseWidget, fe, userData, PhotoIdViewerListWidget, PhotoIdViewerOptionsWidget, ButtonsPane, PhotoIdViewerGrid, rpc, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      lex = _lexs[0];

  var tpl = function tpl() {
    return "<div class=\"PhotoIdContainer\">\n                        <div class=\"wrapperContainer leftContainerVisible\"> \n                          <div class=\"leftContainer\">\n                            <div class=\"PhotoIdViewerListWidget\" />\n                            <div class=\"PhotoIdViewerOptionsWidget\" />\n                            <div class=\"AddReaderCameraContainer\" />\n                          </div>\n                          <div class=\"rightContainer\" />\n                       </div>\n                     </div>";
  };
  /**
   * Widget for the Photo ID viewer. Loads all the PhotoID viewer widgets containing the
   * grid layout, camera and reader adding options
   *
   * @private
   * @class
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @alias module:nmodule/entsecHx/rc/photoID/PhotoIDsUxView
   */


  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(PhotoIDsUxView, _BaseWidget);

    var _super = _createSuper(PhotoIDsUxView);

    function PhotoIDsUxView(params) {
      var _this;

      _classCallCheck(this, PhotoIDsUxView);

      _this = _super.call(this, params);
      _this.$collapseCommand = new Command({
        module: 'videoDriver',
        lex: 'collapseCommand',
        func: function func() {
          return _this.$invokeToggle();
        }
      });

      _this.getCommandGroup().add(_this.$collapseCommand);

      subscriberMixIn(_assertThisInitialized(_this));
      return _this;
    }
    /**
     * Initializes the dom.
     *
     * @param {jquery} dom
     * @returns {Promise}
     */


    _createClass(PhotoIDsUxView, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        dom.html(tpl()).addClass('PhotoIDsUxView');
        dom.on(events.MODIFY_EVENT, '.PhotoIdViewerOptionsWidget', function () {
          _this2.$invokeViewRefresh()["catch"](baja.error);

          return false;
        }).on('removeDevice', '.PhotoIdViewerListWidget', function (event, slotPath, className) {
          _this2.$invokeRemoveDevice(slotPath, className)["catch"](baja.error);

          return false;
        }).on('removeFromView', '.PhotoIdViewerListWidget', function (event, device) {
          _this2.$invokeRemoveFromView(device)["catch"](baja.error);

          return false;
        }).on('cameraAdded', '.AddReaderCameraContainer', function (event, selectedRows) {
          _this2.$addCameraList(selectedRows)["catch"](baja.error);

          return false;
        }).on('readerAdded', '.AddReaderCameraContainer', function (event, selectedRows) {
          _this2.$addReaderList(selectedRows)["catch"](baja.error);

          return false;
        });
      }
      /**
       * @private
       * @param {Array<string>} ordStrList
       * @returns {Array<string>}
       */

    }, {
      key: "$removeDuplicates",
      value: function $removeDuplicates(ordStrList) {
        var ordMap = {};
        ordStrList.forEach(function (ordStr) {
          var splitStr = ordStr.split('station:|');
          ordMap[splitStr[1]] = ordStr;
        });
        return Object.values(ordMap);
      }
      /**
       * @private
       * @param {Array<string>} selectedRows
       * @returns {Promise.constructor|Promise<Promise>}
       */

    }, {
      key: "$addCameraList",
      value: function $addCameraList(selectedRows) {
        var _this3 = this;

        var finalList = [];
        var currentOrdList;

        if (currentOrdList = this.value().get('currentOrdList')) {
          currentOrdList.getOrds().forEach(function (ord) {
            finalList.push(ord.$ord);
          });
        } // Concat the lists and remove duplicates if any.


        var uniqueOrdList = this.$removeDuplicates(finalList.concat(Object.keys(selectedRows).map(function (key) {
          return 'station:|' + key;
        })));
        return this.saveCurrentOrdList(uniqueOrdList).then(function () {
          return _this3.$makePhotoIdViewerListWidget();
        });
      }
      /**
       * @private
       * @param {Array<string>} selectedRows
       * @returns {Promise}
       */

    }, {
      key: "$addReaderList",
      value: function $addReaderList(selectedRows) {
        var _this4 = this;

        return rpc.getOrd('service:entsec:PhotoIDNetwork', {
          lease: true
        }).then(function (photoIdNetwork) {
          var finalList = [];
          var currentOrdList;

          if (currentOrdList = _this4.value().get('currentOrdList')) {
            currentOrdList.getOrds().forEach(function (ord) {
              finalList.push(ord.$ord);
            });
          } // Concat both lists.


          Object.keys(selectedRows).forEach(function (key) {
            finalList.push('station:|' + photoIdNetwork.getSlotPath().toString() + '/' + baja.SlotPath.escape(key));
          }); // Remove the duplicates if any.

          var uniqueOrdList = _this4.$removeDuplicates(finalList);

          return _this4.saveCurrentOrdList(uniqueOrdList).then(function () {
            return _this4.$makePhotoIdViewerListWidget();
          });
        });
      }
      /**
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$makePhotoIdViewerListWidget",
      value: function $makePhotoIdViewerListWidget() {
        return fe.buildFor({
          formFactor: 'mini',
          type: PhotoIdViewerListWidget,
          dom: this.$getPhotoIdListElement(),
          value: this.value()
        });
      }
      /**
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$invokeViewRefresh",
      value: function $invokeViewRefresh() {
        return Promise.all([this.$reloadGrid(), this.save()]);
      }
      /**
       * @private
       * @param {string} slotPath
       * @param {string} className
       * @returns {Promise}
       */

    }, {
      key: "$invokeRemoveDevice",
      value: function $invokeRemoveDevice(slotPath, className) {
        var _this5 = this;

        var currentOrdList = this.value().get('currentOrdList');
        currentOrdList = currentOrdList ? currentOrdList.getOrds() : [];
        var modifiedOrdList = currentOrdList.filter(function (ord) {
          return ord.$ord.indexOf(slotPath) === -1;
        });
        return Promise.all([this.saveCurrentOrdList(modifiedOrdList), this.$invokeRemoveFromView(slotPath)]).then(function () {
          _this5.jq().find(".".concat(className)).remove();
        });
      }
      /**
       * Saves the current ord list to the PhotoIdViewer.
       *
       * @param {Array<baja.Ord>} ordList
       * @returns {Promise}
       */

    }, {
      key: "saveCurrentOrdList",
      value: function saveCurrentOrdList(ordList) {
        var _this6 = this;

        if (this.$hasAdminWrite()) {
          // In case if we do not have the slot created.
          var addPromise = Promise.resolve();

          if (this.value().get('currentOrdList') === null) {
            addPromise = this.value().add({
              slot: 'currentOrdList',
              value: baja.OrdList.DEFAULT
            });
          }

          return addPromise.then(function () {
            return _this6.value().set({
              slot: 'currentOrdList',
              value: baja.OrdList.make(ordList)
            });
          });
        }
      }
      /**
       * @private
       * @param slotPath
       * @returns {Promise}
       */

    }, {
      key: "$invokeRemoveFromView",
      value: function $invokeRemoveFromView(slotPath) {
        var _this7 = this;

        return Promise.map(_toConsumableArray(Array(16).keys()), function (index) {
          var cameraId = 'camera' + (index + 1);

          var cameraOrd = _this7.value()["get".concat(cameraId.capitalizeFirstLetter())]();

          if (cameraOrd.$ord.indexOf(slotPath) !== -1) {
            return _this7.value().set({
              slot: cameraId,
              value: baja.Ord.DEFAULT
            });
          }
        }).then(function () {
          return _this7.$reloadGrid();
        });
      }
      /**
       * @param {baja.Component} value - the agent value on which PhotoIDsUxView
       * is registered on.
       */

    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this8 = this;

        if (baja.hasType(value, 'videoDriver:VideoPlaybackMultistream')) {
          return Promise.all(this.$getFieldEditors(value)).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 4),
                cameraListContainer = _ref2[0],
                photoIdOptionsWidget = _ref2[1],
                buttonsPaneWidget = _ref2[2],
                isLeftContainerVisible = _ref2[3];

            _this8.$photoIdListContainer = cameraListContainer;
            _this8.$photoIdOptionsWidget = photoIdOptionsWidget;
            _this8.$buttonsPaneWidget = buttonsPaneWidget;

            if (!isLeftContainerVisible) {
              _this8.$hideLeftContainer();
            }

            return Promise.all([_this8.$loadGridView(value), _this8.$collapseCommand.setEnabled(_this8.$hasAdminWrite())]);
          });
        } else {
          throw new Error('Invalid Type');
        }
      }
      /**
       * @private
       * @param  {baja.Component} value - the agent value on which PhotoIDsUxView
       * @returns {Array<Promise>}
       */

    }, {
      key: "$getFieldEditors",
      value: function $getFieldEditors(value) {
        return [fe.buildFor({
          formFactor: 'mini',
          type: PhotoIdViewerListWidget,
          dom: this.$getPhotoIdListElement(),
          value: value
        }), fe.buildFor({
          formFactor: 'mini',
          type: PhotoIdViewerOptionsWidget,
          dom: this.$getPhotoIdOptionsElement(),
          value: value
        }), fe.buildFor({
          formFactor: 'mini',
          type: ButtonsPane,
          dom: this.$getButtonsPaneElement(),
          value: value
        }), userData.get(this.$getProfileKey()).then(JSON.parse)];
      }
      /**
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$loadGridView",
      value: function $loadGridView(value) {
        return fe.buildFor({
          formFactor: 'mini',
          type: PhotoIdViewerGrid,
          dom: this.$getPhotoIdViewerGridElement(),
          value: this.value(),
          properties: {
            layoutType: value.getLayout()
          }
        });
      }
      /**
       * Reads the surveillance options widget.
       *
       * @returns {Promise}
       */

    }, {
      key: "doRead",
      value: function doRead() {
        return this.$photoIdOptionsWidget.read();
      }
      /**
       * Saves all child widgets
       *
       * @returns {Promise}
       */

    }, {
      key: "doSave",
      value: function doSave() {
        if (this.$hasAdminWrite()) {
          return this.getChildWidgets().saveAll();
        }
      }
      /**
       * @private
       * @returns {jquery}
       */

    }, {
      key: "$getButtonsPaneElement",
      value: function $getButtonsPaneElement() {
        return this.jq().find('.AddReaderCameraContainer');
      }
      /**
       * @private
       * @returns {baja.Widget}
       */

    }, {
      key: "$getButtonsPaneWidget",
      value: function $getButtonsPaneWidget() {
        return Widget["in"](this.$getButtonsPaneElement());
      }
      /**
       * Invokes the toggle command action.
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$invokeToggle",
      value: function $invokeToggle() {
        var isLeftContainerVisible = this.$isLeftContainerVisible();

        if (isLeftContainerVisible) {
          this.$hideLeftContainer();
        } else {
          this.$showLeftContainer();
        } // Reload the grid when there's a change in layout size.


        return Promise.all([userData.put(this.$getProfileKey(), JSON.stringify(!isLeftContainerVisible)), this.$reloadGrid()]);
      }
      /**
       * Reloads the surveillance viewer grid.
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$reloadGrid",
      value: function $reloadGrid() {
        var _this9 = this;

        return this.read().then(function (value) {
          return _this9.$loadGridView(value);
        });
      }
      /**
       * @private
       * @returns {jquery}
       */

    }, {
      key: "$getPhotoIdListElement",
      value: function $getPhotoIdListElement() {
        return this.jq().find('.PhotoIdViewerListWidget');
      }
      /**
       * @private
       * @returns {module:nmodule/entsecHx/rc/photoID/PhotoIdViewerListWidget}
       */

    }, {
      key: "$getPhotoIdListWidget",
      value: function $getPhotoIdListWidget() {
        return Widget["in"](this.$getPhotoIdListElement());
      }
      /**
       * @private
       * @returns {jquery}
       */

    }, {
      key: "$getPhotoIdOptionsElement",
      value: function $getPhotoIdOptionsElement() {
        return this.jq().find('.PhotoIdViewerOptionsWidget');
      }
      /**
       * @private
       * @returns {jquery}
       */

    }, {
      key: "$getPhotoIdViewerGridElement",
      value: function $getPhotoIdViewerGridElement() {
        return this.jq().find('.rightContainer');
      }
      /**
       * @private
       * @returns {jquery}
       */

    }, {
      key: "$getSurveillanceGridWidget",
      value: function $getSurveillanceGridWidget() {
        return Widget["in"](this.$getPhotoIdViewerGridElement());
      }
      /**
       * @private
       * @returns {module:nmodule/entsecHx/rc/photoID/PhotoIdViewerOptionsWidget}
       */

    }, {
      key: "$getPhotoIdOptionsWidget",
      value: function $getPhotoIdOptionsWidget() {
        return Widget["in"](this.$getPhotoIdOptionsElement());
      }
      /**
       * @private
       */

    }, {
      key: "$hideLeftContainer",
      value: function $hideLeftContainer() {
        this.jq().find('.wrapperContainer').toggleClass('leftContainerVisible', false);
        this.jq().find('.wrapperContainer').toggleClass('leftContainerHidden', true);
        this.$collapseCommand.setIcon(lex.get('restoreCommand.icon'));
        this.$collapseCommand.setDescriptionFormat(lex.get('restoreCommand.description'));
        this.$collapseCommand.setDisplayNameFormat(lex.get('restoreCommand.displayName'));
        this.jq().find('.leftContainer').animate({
          width: 'toggle'
        });
      }
      /**
       * @private
       */

    }, {
      key: "$showLeftContainer",
      value: function $showLeftContainer() {
        this.jq().find('.wrapperContainer').toggleClass('leftContainerHidden', false);
        this.jq().find('.wrapperContainer').toggleClass('leftContainerVisible', true);
        this.$collapseCommand.setIcon(lex.getSafe('collapseCommand.icon'));
        this.$collapseCommand.setDescriptionFormat(lex.getSafe('collapseCommand.description'));
        this.$collapseCommand.setDisplayNameFormat(lex.getSafe('collapseCommand.displayName'));
        this.jq().find('.leftContainer').animate({
          width: 'toggle'
        });
      }
      /**
       * @private
       * @returns boolean
       */

    }, {
      key: "$hasAdminWrite",
      value: function $hasAdminWrite() {
        return this.value().getPermissions().hasAdminWrite();
      }
      /**
       * @private
       * @returns {string}
       */

    }, {
      key: "$getProfileKey",
      value: function $getProfileKey() {
        return 'isPhotoIdLeftContainerVisible';
      }
      /**
       * @private
       * @returns {boolean}
       */

    }, {
      key: "$isLeftContainerVisible",
      value: function $isLeftContainerVisible() {
        return this.jq().find('.leftContainer').is(':visible');
      }
      /**
       * Destroys the editor and all children of the editor.
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('PhotoIDsUxView');
        return this.getChildWidgets().destroyAll();
      }
    }]);

    return PhotoIDsUxView;
  }(BaseWidget);
});
