/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

define([
  'baja!',
  'baja!' +
  'bql:DynamicTimeRange,bql:FilterSet,bql:FilterEntry'
], function (baja) {
  "use strict";

  /**
   * API Status: **Private**
   *
   * A set of utility functions for the history module.
   *
   * @exports nmodule/history/rc/historyUtil
   */
  var historyUtil = {};

  /**
   * Determine whether the following DynamicTimeRange includes now or not
   * @param {baja.Simple} dynamicTimeRange `bql:DynamicTimeRange`
   * @returns {boolean}
   */
  historyUtil.isLive = function (dynamicTimeRange) {

    if (!dynamicTimeRange) {
      return true;
    }
    var encoding = dynamicTimeRange.encodeToString();
    if (encoding.indexOf("timeRange:") === 0) {
      if (encoding.indexOf("endTime") < 0) {
        return true; //no end
      }
      var endEncoding = encoding.split('endTime=')[1];
      var endTime = baja.AbsTime.DEFAULT.decodeFromString(endEncoding);

      return endTime.equals(baja.AbsTime.DEFAULT) || endTime.valueOf() > baja.AbsTime.now().valueOf(); //true if endTime is beyond now
    }
    switch (encoding) {

      case 'today':
      case 'last24Hours':
      case 'weekToDate':
      case 'last7Days':
      case 'monthToDate':
      case 'yearToDate':
        return true;
      case 'yesterday':
      case 'lastWeek':
      case 'lastMonth':
      case 'lastYear':
        return false;
    }
  };

  /**
   * Convert a DynamicTimeRange to a historyScheme paramter String
   * @param {baja.Simple} dynamicTimeRange `bql:DynamicTimeRange`
   * @returns {String}
   */
  historyUtil.toHistoryParameter = function (dynamicTimeRange) {
    var encoding = dynamicTimeRange.encodeToString();
    encoding = encoding.replace(/Time/g, "");
    if (encoding.indexOf("start") !== 0 && encoding.indexOf("end") !== 0) {
      if (encoding.indexOf("timeRange:") === 0) {
        encoding = encoding.substring("timeRange:".length);
      } else {
        encoding = "period=" + encoding;
      }
    }
    return encoding;
  };

  /**
   *
   * @param {baja.Component} filterSet `bql:FilterEntry`
   * @returns {boolean}
   */
  historyUtil.anyActive = function (filterSet) {
    var anyActive = false;
    filterSet.getSlots().properties().is('bql:FilterEntry')
      .each(function (slot) {
        var filterEntry = this.get(slot);
        if (filterEntry.get('active')) {
          anyActive = true;
        }
      });
    return anyActive;
  };


  return historyUtil;
})
;
