/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/fe/BasicActivePeriodEditor
 */
define(['lex!history',
        'baja!',
        'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor',
        'hbs!nmodule/history/rc/fe/templates/BasicActivePeriodEditor'], function (
         lexs,
         baja,
         ComplexCompositeEditor,
         tplBasicActivePeriodEditor) {

    'use strict';

  var historyLex = lexs[0],
      tpl = function() {
        return tplBasicActivePeriodEditor({
          lexLabel: {
            daysOfWeek: historyLex.get('basicActivePeriodFE.daysOfWeek'),
            timeRange: historyLex.get('basicActivePeriodFE.timeRange')
          }
        });
      };

  /**
  * Editor for editing the `daysOfWeek`, and `timeRange` slots of a
  * `history:BasicActivePeriod`.
  *
  * @class
  * @alias nmodule/history/rc/fe/BasicActivePeriodEditor
  * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
  */
  var BasicActivePeriodEditor = function BasicActivePeriodEditor() {
    ComplexCompositeEditor.apply(this, arguments);
  };
  BasicActivePeriodEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  BasicActivePeriodEditor.prototype.constructor = BasicActivePeriodEditor;

  /**
  * Initialize editors for the `daysOfWeek` and `timeRange` slots.
  *
  * @returns {Array}
  */
  BasicActivePeriodEditor.prototype.getSlotFilter = function () {
    return ['daysOfWeek', 'timeRange'];
  };

  BasicActivePeriodEditor.prototype.$buildSubEditorDom = function (slot) {
    return this.jq().find('.js-' + slot);
  };

  BasicActivePeriodEditor.prototype.doInitialize = function (dom) {
    dom.addClass('BasicActivePeriodEditor').html(tpl(this));
    return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  BasicActivePeriodEditor.prototype.doDestroy = function () {
    this.jq().removeClass('BasicActivePeriodEditor');
    return ComplexCompositeEditor.prototype.doDestroy.apply(this, arguments);
  };

  return BasicActivePeriodEditor;
});
