/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.workbench.popup;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.BWbEditor;

/**
 * The popup editor interface is implemented by classes that will be used for
 * rounded window popup displays in the workbench. 
 *
 * @author J. Spangler
 * @creation Apr 17, 2012
 *
 */
public interface BIPopupEditor
    extends BInterface
{
  
  public static final Type TYPE = Sys.loadType(BIPopupEditor.class);

  /**
   * This method returns the {@link BWbEditor} displayed in the rounded popup
   * display.
   * 
   * @return {@link BWbEditor}
   */
  public BWbEditor getEditor();

}
