/*
 * Copyright 2011, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.web.mobile;

import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * A Mobile Web Operational View
 *
 * @author		gjohnson
 * @creation 	4 Aug 2011
 * @version 	1
 * @since 		Niagara 3.7
 */
public interface BIMobileWebOperationalView
    extends BIMobileWebView
{
  public static final Type TYPE = Sys.loadType(BIMobileWebOperationalView.class);
  
  /**
   * Return true if the view is operational and can be used.
   * <p>
   * Please note, as any concrete implementations should make this method
   * final as license checks could be performed.
   */
  public boolean isOperational(Context cx);
}
