/*
 * Copyright 2012, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.web.mobile;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebProfileConfig;

/**
 * An interface implemented by all Themes used with Mobile.
 *
 * @author JJ Frankovich
 * @since Niagara 4.6
 */
public interface BIMobileTheme
  extends BInterface
{
  public static final Type TYPE = Sys.loadType(BIMobileTheme.class);

  /**
   * Override this method to choose the desired bajaux theme. Defaults to Zebra
   */
  default String getBajauxThemeName(BWebProfileConfig mobileConfig)
  {
    return "Zebra";
  }

}