/*
 * Copyright 2013, Tridium Inc, All Rights Rervered.
 */
package javax.baja.web.js;

import javax.baja.agent.BIAgent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 * An interface for JavaScript resources.
 * <p>
 * A class that implements this interface provides some JavaScript
 * resources. The referenced file contains 
 * some modular JavaScript that uses the AMD format.
 * 
 * @see <a href="http://requirejs.org/docs/whyamd.html">RequireJS documentation</a>
 * @see JsInfo
 *
 * @author   Gareth Johnson
 * @creation 12 Jun 2013
 * @since    Niagara 4.0
 */
public interface BIJavaScript
    extends BIAgent
{
  public static final Type TYPE = Sys.loadType(BIJavaScript.class);
  
  /**
   * Return the AMD JavaScript entry point.
   * 
   * @param cx
   * @return
   */
  public JsInfo getJsInfo(Context cx);
}
