/**
 * Copyright 2011 - Tridium Inc, All Rights Reserved.
 */

package javax.baja.web;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BXFrameOptionsEnum is a list of the supported options for the xframe options header
 * 
 * @author    $Bill Smith
 * @creation  Nov 14, 2014
 * @version   $Revision$ $Date$
 * @since     Niagara 3.7
 */

public final class BXFrameOptionsEnum
    extends BFrozenEnum
{
  /*-
   enum BXFrameOptionsEnum
   {
     range
     {
       deny,
       sameorigin,
       any,
     }

     default {[ sameorigin ]}
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.web.BXFrameOptionsEnum(1079051127)1.0$ @*/
/* Generated Fri Nov 14 15:21:15 EST 2014 by Slot-o-Matic (c) Tridium, Inc. 2012 */
  
  /** Ordinal value for deny. */
  public static final int DENY = 0;
  /** Ordinal value for sameorigin. */
  public static final int SAMEORIGIN = 1;
  /** Ordinal value for any. */
  public static final int ANY = 2;
  
  /** BXFrameOptionsEnum constant for deny. */
  public static final BXFrameOptionsEnum deny = new BXFrameOptionsEnum(DENY);
  /** BXFrameOptionsEnum constant for sameorigin. */
  public static final BXFrameOptionsEnum sameorigin = new BXFrameOptionsEnum(SAMEORIGIN);
  /** BXFrameOptionsEnum constant for any. */
  public static final BXFrameOptionsEnum any = new BXFrameOptionsEnum(ANY);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BXFrameOptionsEnum.class);
  
  /** Factory method with ordinal. */
  public static BXFrameOptionsEnum make(int ordinal)
  {
    return (BXFrameOptionsEnum)deny.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BXFrameOptionsEnum make(String tag)
  {
    return (BXFrameOptionsEnum)deny.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BXFrameOptionsEnum(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BXFrameOptionsEnum DEFAULT = sameorigin;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
