/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.web;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Specifies a JNLP file download policy.
 *
 * @author Gareth Johnson on 01/06/2015
 * @since Niagara 4.0
 */
public final class BJnlpDownloadPolicy extends BFrozenEnum
{
/*-
  enum BJnlpDownloadPolicy
  {
    range
    {
      whenNotAvailable,
      never,
      always
    }
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.web.BJnlpDownloadPolicy(2825633299)1.0$ @*/
/* Generated Mon Jun 01 19:25:50 BST 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */
  
  /** Ordinal value for whenNotAvailable. */
  public static final int WHEN_NOT_AVAILABLE = 0;
  /** Ordinal value for never. */
  public static final int NEVER = 1;
  /** Ordinal value for always. */
  public static final int ALWAYS = 2;
  
  /** BJnlpDownloadPolicy constant for whenNotAvailable. */
  public static final BJnlpDownloadPolicy whenNotAvailable = new BJnlpDownloadPolicy(WHEN_NOT_AVAILABLE);
  /** BJnlpDownloadPolicy constant for never. */
  public static final BJnlpDownloadPolicy never = new BJnlpDownloadPolicy(NEVER);
  /** BJnlpDownloadPolicy constant for always. */
  public static final BJnlpDownloadPolicy always = new BJnlpDownloadPolicy(ALWAYS);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BJnlpDownloadPolicy.class);
  
  /** Factory method with ordinal. */
  public static BJnlpDownloadPolicy make(int ordinal)
  {
    return (BJnlpDownloadPolicy)whenNotAvailable.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BJnlpDownloadPolicy make(String tag)
  {
    return (BJnlpDownloadPolicy)whenNotAvailable.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BJnlpDownloadPolicy(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BJnlpDownloadPolicy DEFAULT = whenNotAvailable;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
