/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.web;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * A marker interface for bajaux Widgets that can be loaded offline.
 * <p>
 * In offline mode, a widget loads all of its resources locally in the Workbench VM.
 * There is no Station Web Server connection. If offline mode, a web application can
 * never make any AJAX requests. BajaScript RPC calls must be used instead.
 * </p>
 * <p>
 * This interface should be used in conjunction with {@link javax.baja.web.js.BIJavaScript}
 * and {@link BIFormFactor} interfaces.
 * </p>
 *
 * @see javax.baja.web.js.BIJavaScript
 * @see BIFormFactor
 *
 * @author Gareth Johnson on 05/10/2015.
 * @since Niagara 4.1
 */
public interface BIOffline extends BInterface
{
  Type TYPE = Sys.loadType(BIOffline.class);
}
