/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package test;

import javax.baja.sys.*;

/**
 * BTester is a quick and dirty component for
 * hand run testing.
 *
 * @author    Brian Frank
 * @creation  1 Apr 01
 * @version   $Revision: 3$ $Date: 12/9/02 8:53:01 AM EST$
 * @since     Baja 1.0
 */
public class BTester
  extends BComponent
{


  /*-

  class BTester
  {
    actions
    {
      none()
      booleanSimple(booleanValue: BBoolean)
        default {[ BBoolean.TRUE ]}
      intSimple(intValue: BInteger)
        default {[ BInteger.make(2) ]}
      floatSimple(floatValue: BFloat)
        default {[ BFloat.make(3) ]}
      stringSimple(stringValue: BString)
        default {[ BString.make("hello world") ]}
      timeSimple(time: BAbsTime)
        default {[ BAbsTime.make() ]}
      linkBaby(value: BLink)
        default {[ new BLink() ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $test.BTester(2292543478)1.0$ @*/
/* Generated Mon Dec 09 08:32:35 EST 2002 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Action "none"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>none</code> action.
   * @see test.BTester#none()
   */
  public static final Action none = newAction(0,null);

  /**
   * Invoke the <code>none</code> action.
   * @see test.BTester#none
   */
  public void none() { invoke(none,null,null); }

////////////////////////////////////////////////////////////////
// Action "booleanSimple"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>booleanSimple</code> action.
   * @see test.BTester#booleanSimple
   */
  public static final Action booleanSimple = newAction(0,BBoolean.TRUE,null);

  /**
   * Invoke the <code>booleanSimple</code> action.
   * @see test.BTester#booleanSimple
   */
  public void booleanSimple(BBoolean booleanValue) { invoke(booleanSimple,booleanValue,null); }

////////////////////////////////////////////////////////////////
// Action "intSimple"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>intSimple</code> action.
   * @see test.BTester#intSimple
   */
  public static final Action intSimple = newAction(0,BInteger.make(2),null);

  /**
   * Invoke the <code>intSimple</code> action.
   * @see test.BTester#intSimple
   */
  public void intSimple(BInteger intValue) { invoke(intSimple,intValue,null); }

////////////////////////////////////////////////////////////////
// Action "floatSimple"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>floatSimple</code> action.
   * @see test.BTester#floatSimple
   */
  public static final Action floatSimple = newAction(0,BFloat.make(3),null);

  /**
   * Invoke the <code>floatSimple</code> action.
   * @see test.BTester#floatSimple
   */
  public void floatSimple(BFloat floatValue) { invoke(floatSimple,floatValue,null); }

////////////////////////////////////////////////////////////////
// Action "stringSimple"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>stringSimple</code> action.
   * @see test.BTester#stringSimple
   */
  public static final Action stringSimple = newAction(0,BString.make("hello world"),null);

  /**
   * Invoke the <code>stringSimple</code> action.
   * @see test.BTester#stringSimple
   */
  public void stringSimple(BString stringValue) { invoke(stringSimple,stringValue,null); }

////////////////////////////////////////////////////////////////
// Action "timeSimple"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>timeSimple</code> action.
   * @see test.BTester#timeSimple
   */
  public static final Action timeSimple = newAction(0,BAbsTime.make(),null);

  /**
   * Invoke the <code>timeSimple</code> action.
   * @see test.BTester#timeSimple
   */
  public void timeSimple(BAbsTime time) { invoke(timeSimple,time,null); }

////////////////////////////////////////////////////////////////
// Action "linkBaby"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>linkBaby</code> action.
   * @see test.BTester#linkBaby
   */
  public static final Action linkBaby = newAction(0,new BLink(),null);

  /**
   * Invoke the <code>linkBaby</code> action.
   * @see test.BTester#linkBaby
   */
  public void linkBaby(BLink value) { invoke(linkBaby,value,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BTester.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Testing
////////////////////////////////////////////////////////////////

  public void doNone()
    { System.out.println("none"); }

  public void doBooleanSimple(BBoolean x)
    { System.out.println("booleanSimple: " + x); }

  public void doIntSimple(BInteger x)
    { System.out.println("intSimple: " + x); }

  public void doFloatSimple(BFloat f)
    { System.out.println("floatSimple: " + f); }

  public void doStringSimple(BString x)
    { System.out.println("stringSimple: " + x); }

  public void doTimeSimple(BAbsTime x)
    { System.out.println("timeSimple: " + x); }

  public void doLinkBaby(BLink x)
    { System.out.println("linkBaby: " + x); }

}
