/*
 * Copyright 2016 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.tagdictionary;

import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;

/** The scope in which this rule applies */
@NiagaraProperty(name = "scopeList", type="BTagRuleScopeList", defaultValue = "new BTagRuleScopeList()")

/**
 * BScopedTagRule is a {@code BTagRule} with a list of scopes in which
 * the rule applies.
 *
 * @author Scott Newton
 * @creation 21 Nov 16
 * @since Niagara 4.3
 */
@NiagaraType
public class BScopedTagRule extends BTagRule
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.tagdictionary.BScopedTagRule(628382274)1.0$ @*/
/* Generated Wed Dec 07 12:46:45 EST 2016 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "scopeList"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code scopeList} property.
   * @see #getScopeList
   * @see #setScopeList
   */
  public static final Property scopeList = newProperty(0, new BTagRuleScopeList(), null);
  
  /**
   * Get the {@code scopeList} property.
   * @see #scopeList
   */
  public BTagRuleScopeList getScopeList() { return (BTagRuleScopeList)get(scopeList); }
  
  /**
   * Set the {@code scopeList} property.
   * @see #scopeList
   */
  public void setScopeList(BTagRuleScopeList v) { set(scopeList, v, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BScopedTagRule.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  /**
   * Default constructor that sets all properties to their default values.
   */
  public BScopedTagRule()
  {
  }

  /**
   * Initializes the {@link #condition} property.
   *
   * @param cond initial value of the {@link #condition} property
   */
  public BScopedTagRule(BTagRuleCondition cond)
  {
    setCondition(cond);
  }

  /**
   * Initializes the {@link #condition} and {@link #scopeList} properties.
   *
   * @param cond initial value of the {@link #condition} property
   * @param scopeList initial value of the {@link #scopeList} property
   */
  public BScopedTagRule(BTagRuleCondition cond, BTagRuleScopeList scopeList)
  {
    setCondition(cond);
    setScopeList(scopeList);
  }

  /**
   * Determine if this rule applies to the supplied entity.
   *
   * @param entity the entity to evaluate this rule against
   * @return {@code true} if the rule applies to the supplied entity; {@code false} otherwise.
   * @since Niagara 4.3
   */
  @Override
  public boolean evaluate(Entity entity)
  {
    return getScopeList().isInScope(entity) && getCondition().test(entity);
  }
}
