/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.serial;

import javax.baja.sys.*;

/**
 * BSerialBaudRate represents the possible baud rate choices
 * for a comm port.
 * <p>
 *
 * @author    Scott Hoye
 * @creation  23 Sep 02
 * @version   $Revision: 6$ $Date: 5/23/05 1:20:35 PM EDT$  
 * @since     Niagara 3.0 serial 1.0
 */

public final class BSerialBaudRate
  extends BBaudRate
{
  /*-
  enum BSerialBaudRate
  {
    range
    {
      baud50 = 50,
      baud75 = 75,
      baud110 = 110,
      baud134 = 134,
      baud150 = 150,
      baud200 = 200,
      baud300 = 300,
      baud600 = 600,
      baud1200 = 1200,
      baud1800 = 1800,
      baud2400 = 2400,
      baud4800 = 4800,
      baud9600 = 9600,
      baud19200 = 19200,
      baud38400 = 38400,
      baud57600 = 57600,
      baud76800 = 76800,
      baud115200 = 115200
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.serial.BSerialBaudRate(597640374)1.0$ @*/
/* Generated Tue Jul 10 12:06:34 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for baud50. */
  public static final int BAUD_50 = 50;
  /** Ordinal value for baud75. */
  public static final int BAUD_75 = 75;
  /** Ordinal value for baud110. */
  public static final int BAUD_110 = 110;
  /** Ordinal value for baud134. */
  public static final int BAUD_134 = 134;
  /** Ordinal value for baud150. */
  public static final int BAUD_150 = 150;
  /** Ordinal value for baud200. */
  public static final int BAUD_200 = 200;
  /** Ordinal value for baud300. */
  public static final int BAUD_300 = 300;
  /** Ordinal value for baud600. */
  public static final int BAUD_600 = 600;
  /** Ordinal value for baud1200. */
  public static final int BAUD_1200 = 1200;
  /** Ordinal value for baud1800. */
  public static final int BAUD_1800 = 1800;
  /** Ordinal value for baud2400. */
  public static final int BAUD_2400 = 2400;
  /** Ordinal value for baud4800. */
  public static final int BAUD_4800 = 4800;
  /** Ordinal value for baud9600. */
  public static final int BAUD_9600 = 9600;
  /** Ordinal value for baud19200. */
  public static final int BAUD_19200 = 19200;
  /** Ordinal value for baud38400. */
  public static final int BAUD_38400 = 38400;
  /** Ordinal value for baud57600. */
  public static final int BAUD_57600 = 57600;
  /** Ordinal value for baud76800. */
  public static final int BAUD_76800 = 76800;
  /** Ordinal value for baud115200. */
  public static final int BAUD_115200 = 115200;
  
  /** BSerialBaudRate constant for baud50. */
  public static final BSerialBaudRate baud50 = new BSerialBaudRate(BAUD_50);
  /** BSerialBaudRate constant for baud75. */
  public static final BSerialBaudRate baud75 = new BSerialBaudRate(BAUD_75);
  /** BSerialBaudRate constant for baud110. */
  public static final BSerialBaudRate baud110 = new BSerialBaudRate(BAUD_110);
  /** BSerialBaudRate constant for baud134. */
  public static final BSerialBaudRate baud134 = new BSerialBaudRate(BAUD_134);
  /** BSerialBaudRate constant for baud150. */
  public static final BSerialBaudRate baud150 = new BSerialBaudRate(BAUD_150);
  /** BSerialBaudRate constant for baud200. */
  public static final BSerialBaudRate baud200 = new BSerialBaudRate(BAUD_200);
  /** BSerialBaudRate constant for baud300. */
  public static final BSerialBaudRate baud300 = new BSerialBaudRate(BAUD_300);
  /** BSerialBaudRate constant for baud600. */
  public static final BSerialBaudRate baud600 = new BSerialBaudRate(BAUD_600);
  /** BSerialBaudRate constant for baud1200. */
  public static final BSerialBaudRate baud1200 = new BSerialBaudRate(BAUD_1200);
  /** BSerialBaudRate constant for baud1800. */
  public static final BSerialBaudRate baud1800 = new BSerialBaudRate(BAUD_1800);
  /** BSerialBaudRate constant for baud2400. */
  public static final BSerialBaudRate baud2400 = new BSerialBaudRate(BAUD_2400);
  /** BSerialBaudRate constant for baud4800. */
  public static final BSerialBaudRate baud4800 = new BSerialBaudRate(BAUD_4800);
  /** BSerialBaudRate constant for baud9600. */
  public static final BSerialBaudRate baud9600 = new BSerialBaudRate(BAUD_9600);
  /** BSerialBaudRate constant for baud19200. */
  public static final BSerialBaudRate baud19200 = new BSerialBaudRate(BAUD_19200);
  /** BSerialBaudRate constant for baud38400. */
  public static final BSerialBaudRate baud38400 = new BSerialBaudRate(BAUD_38400);
  /** BSerialBaudRate constant for baud57600. */
  public static final BSerialBaudRate baud57600 = new BSerialBaudRate(BAUD_57600);
  /** BSerialBaudRate constant for baud76800. */
  public static final BSerialBaudRate baud76800 = new BSerialBaudRate(BAUD_76800);
  /** BSerialBaudRate constant for baud115200. */
  public static final BSerialBaudRate baud115200 = new BSerialBaudRate(BAUD_115200);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSerialBaudRate.class);
  
  /** Factory method with ordinal. */
  public static BSerialBaudRate make(int ordinal)
  {
    return (BSerialBaudRate)baud50.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BSerialBaudRate make(String tag)
  {
    return (BSerialBaudRate)baud50.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BSerialBaudRate(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BSerialBaudRate DEFAULT = BSerialBaudRate.baud50;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}