/*
 * Copyright 2001 Tridium, Inc.  All rights reserved.
 */

package javax.baja.schedule;

import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/**
 * A week schedule with special events and an effective period.
 * @author Aaron Hansen
 * @creation Oct 2001
 * @version $Revision: 19$ $Date: 3/4/11 9:30:26 AM EST$
 */
public abstract class BWeeklySchedule
  extends BControlSchedule
{

  /////////////////////////////////////////////////////////////////
  // Properties
  /////////////////////////////////////////////////////////////////

  /*-
  class BWeeklySchedule
  {
    properties
    {
      effective: BDateRangeSchedule
        flags {hidden, operator}
        default {[new BDateRangeSchedule()]}
      schedule: BCompositeSchedule
        flags {hidden, operator}
        default {[makeSchedule()]}
      outSource: String
        flags {operator, readonly,summary,transient, no_audit}
        default {[""]}
    }
    actions
    {
    }
    topics
    {
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.schedule.BWeeklySchedule(960855719)1.0$ @*/
/* Generated Thu Jul 16 14:36:41 EDT 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "effective"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code effective} property.
   * @see javax.baja.schedule.BWeeklySchedule#getEffective
   * @see javax.baja.schedule.BWeeklySchedule#setEffective
   */
  public static final Property effective = newProperty(Flags.HIDDEN|Flags.OPERATOR, new BDateRangeSchedule(),null);

  /**
   * Get the {@code effective} property.
   * @see javax.baja.schedule.BWeeklySchedule#effective
   */
  public BDateRangeSchedule getEffective() { return (BDateRangeSchedule)get(effective); }

  /**
   * Set the {@code effective} property.
   * @see javax.baja.schedule.BWeeklySchedule#effective
   */
  public void setEffective(BDateRangeSchedule v) { set(effective,v,null); }

////////////////////////////////////////////////////////////////
// Property "schedule"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code schedule} property.
   * @see javax.baja.schedule.BWeeklySchedule#getSchedule
   * @see javax.baja.schedule.BWeeklySchedule#setSchedule
   */
  public static final Property schedule = newProperty(Flags.HIDDEN|Flags.OPERATOR, makeSchedule(),null);

  /**
   * Get the {@code schedule} property.
   * @see javax.baja.schedule.BWeeklySchedule#schedule
   */
  public BCompositeSchedule getSchedule() { return (BCompositeSchedule)get(schedule); }

  /**
   * Set the {@code schedule} property.
   * @see javax.baja.schedule.BWeeklySchedule#schedule
   */
  public void setSchedule(BCompositeSchedule v) { set(schedule,v,null); }

////////////////////////////////////////////////////////////////
// Property "outSource"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code outSource} property.
   * @see javax.baja.schedule.BWeeklySchedule#getOutSource
   * @see javax.baja.schedule.BWeeklySchedule#setOutSource
   */
  public static final Property outSource = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.SUMMARY|Flags.TRANSIENT|Flags.NO_AUDIT, "",null);

  /**
   * Get the {@code outSource} property.
   * @see javax.baja.schedule.BWeeklySchedule#outSource
   */
  public String getOutSource() { return getString(outSource); }

  /**
   * Set the {@code outSource} property.
   * @see javax.baja.schedule.BWeeklySchedule#outSource
   */
  public void setOutSource(String v) { setString(outSource,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BWeeklySchedule.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /////////////////////////////////////////////////////////////////
  // Constructors
  /////////////////////////////////////////////////////////////////

  public BWeeklySchedule() { }


  /////////////////////////////////////////////////////////////////
  // Methods - Public and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  public void addSpecialEvent(String name, BDailySchedule specialEvent)
  {
    addSpecialEvent(name, specialEvent, null);
  }

  public void addSpecialEvent(String name, BDailySchedule specialEvent, Context cx)
  {
    getSpecialEvents().add(name, specialEvent, cx);
  }


  /**
   * Set the effectivePeriod and overridableWeely slots to new
   * instances, doesn't clear the old ones.
   */
  public void clear()
  {
    setEffective(new BDateRangeSchedule());
    setSchedule(makeSchedule());
  }

  /**
   * Removes expired special events.
   */
  @Override
  public void doCleanup()
  {
    BCompositeSchedule spec = getSpecialEvents();
    BAbstractSchedule[] ary = spec.getSchedules();
    BDailySchedule md;
    for (int i = ary.length; --i >= 0; )
    {
      // Issue 18858: casting exceptions thrown on clean up of weekly schedule
      if (ary[i] instanceof BDailySchedule)
      {
        md = (BDailySchedule) ary[i];
        if (isExpired(md.getDays()))
        {
          log.info(
            toPathString() + " removing expired special event " + md.getName());
          spec.remove(md);
        }
      }
    }
  }

  public BDaySchedule get(BWeekday day)
  {
    return getWeek().get(day);
  }

  public String getSummary(BAbstractSchedule outputSource)
  {
    String ret = null;
    if ((outputSource == this) || (outputSource == null))
    {
      ret = lex.getText("summary.defaultOutput");
    }
    else
    {
      BComplex c = outputSource.getParent().getParent().getParent();
      if (c instanceof BWeekSchedule)
        ret = lex.getText("summary.weeklySchedule");
      else
        ret = lex.getText("summary.specialEvent");
      ret += ": " + SlotPath.unescape(outputSource.getParent().getParent().getName());
    }
    return ret;
  }

  /**
   * The special event container.
   */
  public final BCompositeSchedule getSpecialEvents()
  {
    return (BCompositeSchedule) getSchedule().get("specialEvents");
  }

  /**
   * The actual special events.
   */
  public BDailySchedule[] getSpecialEventsChildren()
  {
    // Issue 18858: casting exceptions thrown on clean up of weekly schedule
    BAbstractSchedule[] kids = getSpecialEvents().getSchedules();
    Array<BDailySchedule> events = new Array<>(BDailySchedule.class, kids.length);
    for (int i = 0; i < kids.length; ++i)
    {
      if (kids[i] instanceof BDailySchedule)
        events.add((BDailySchedule)kids[i]);
    }
    return events.trim();
  }

  public final BWeekSchedule getWeek()
  {
    return (BWeekSchedule) getSchedule().get("week");
  }

  @Override
  public BAbsTime nextEvent(BAbsTime after)
  {
    BAbsTime sch = getSchedule().nextEvent(after);
    if (sch == null)
      return null;
    BAbsTime eff = getEffective().nextEvent(after);
    if (eff == null)
      return sch;
    if (sch.compareTo(eff) < 0)
      return sch;
    return eff;
  }


  /////////////////////////////////////////////////////////////////
  // Methods - Protected and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  @Override
  protected void currentOutputSource(BAbstractSchedule sch)
  {
    if (sch == last)
      return;
    last = sch;
    setOutSource(getSummary(sch));
  }

  @Override
  protected void currentOutputSourceIsInput()
  {
    last = null;
    setOutSource(lex.getText("summary.input"));
  }

  static BCompositeSchedule makeSchedule()
  {
    BCompositeSchedule retern = new BCompositeSchedule();
    retern.add("specialEvents", new BCompositeSchedule());
    retern.add("week", new BWeekSchedule());
    return retern;
  }


  /////////////////////////////////////////////////////////////////
  // Inner Classes - in alphabetical order by class name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Constants - in alphabetical order by field name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Attributes - in alphabetical order by field name.
  /////////////////////////////////////////////////////////////////

  private BAbstractSchedule last;

  static Lexicon lex = Lexicon.make(BWeeklySchedule.class);

  /////////////////////////////////////////////////////////////////
  // Initialization
  /////////////////////////////////////////////////////////////////


}//BWeeklySchedule
