/*
 * Copyright 2001 Tridium, Inc.  All rights reserved.
 */

package javax.baja.schedule;

import javax.baja.sys.*;
import javax.baja.util.*;

/**
 * @author Aaron Hansen
 * @creation Aug 2002
 * @version $Revision: 18$ $Date: 7/17/09 10:08:13 AM EDT$
 */
public class BCustomSchedule
  extends BCompositeSchedule
  //implements
{

  /////////////////////////////////////////////////////////////////
  // Properties
  /////////////////////////////////////////////////////////////////

  public static final Property union = newProperty(Flags.USER_DEFINED_1 | Flags.READONLY, false,null);

  /*-
  class BCustomSchedule
  {
    properties
    {
      daysOfMonth: BDayOfMonthSchedule
        default {[new BDayOfMonthSchedule()]}
      months: BMonthSchedule
        default {[new BMonthSchedule()]}
      weekdays: BWeekdaySchedule
        default {[new BWeekdaySchedule()]}
      weeksOfMonth: BWeekOfMonthSchedule
        default {[new BWeekOfMonthSchedule()]}
      year: BYearSchedule
        default {[new BYearSchedule().initAlwaysEffective(true)]}
    }
    actions
    {
    }
    topics
    {
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.schedule.BCustomSchedule(3485236853)1.0$ @*/
/* Generated Fri Sep 10 15:05:42 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "daysOfMonth"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code daysOfMonth} property.
   * @see javax.baja.schedule.BCustomSchedule#getDaysOfMonth
   * @see javax.baja.schedule.BCustomSchedule#setDaysOfMonth
   */
  public static final Property daysOfMonth = newProperty(0, new BDayOfMonthSchedule(),null);

  /**
   * Get the {@code daysOfMonth} property.
   * @see javax.baja.schedule.BCustomSchedule#daysOfMonth
   */
  public BDayOfMonthSchedule getDaysOfMonth() { return (BDayOfMonthSchedule)get(daysOfMonth); }

  /**
   * Set the {@code daysOfMonth} property.
   * @see javax.baja.schedule.BCustomSchedule#daysOfMonth
   */
  public void setDaysOfMonth(BDayOfMonthSchedule v) { set(daysOfMonth,v,null); }

////////////////////////////////////////////////////////////////
// Property "months"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code months} property.
   * @see javax.baja.schedule.BCustomSchedule#getMonths
   * @see javax.baja.schedule.BCustomSchedule#setMonths
   */
  public static final Property months = newProperty(0, new BMonthSchedule(),null);

  /**
   * Get the {@code months} property.
   * @see javax.baja.schedule.BCustomSchedule#months
   */
  public BMonthSchedule getMonths() { return (BMonthSchedule)get(months); }

  /**
   * Set the {@code months} property.
   * @see javax.baja.schedule.BCustomSchedule#months
   */
  public void setMonths(BMonthSchedule v) { set(months,v,null); }

////////////////////////////////////////////////////////////////
// Property "weekdays"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code weekdays} property.
   * @see javax.baja.schedule.BCustomSchedule#getWeekdays
   * @see javax.baja.schedule.BCustomSchedule#setWeekdays
   */
  public static final Property weekdays = newProperty(0, new BWeekdaySchedule(),null);

  /**
   * Get the {@code weekdays} property.
   * @see javax.baja.schedule.BCustomSchedule#weekdays
   */
  public BWeekdaySchedule getWeekdays() { return (BWeekdaySchedule)get(weekdays); }

  /**
   * Set the {@code weekdays} property.
   * @see javax.baja.schedule.BCustomSchedule#weekdays
   */
  public void setWeekdays(BWeekdaySchedule v) { set(weekdays,v,null); }

////////////////////////////////////////////////////////////////
// Property "weeksOfMonth"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code weeksOfMonth} property.
   * @see javax.baja.schedule.BCustomSchedule#getWeeksOfMonth
   * @see javax.baja.schedule.BCustomSchedule#setWeeksOfMonth
   */
  public static final Property weeksOfMonth = newProperty(0, new BWeekOfMonthSchedule(),null);

  /**
   * Get the {@code weeksOfMonth} property.
   * @see javax.baja.schedule.BCustomSchedule#weeksOfMonth
   */
  public BWeekOfMonthSchedule getWeeksOfMonth() { return (BWeekOfMonthSchedule)get(weeksOfMonth); }

  /**
   * Set the {@code weeksOfMonth} property.
   * @see javax.baja.schedule.BCustomSchedule#weeksOfMonth
   */
  public void setWeeksOfMonth(BWeekOfMonthSchedule v) { set(weeksOfMonth,v,null); }

////////////////////////////////////////////////////////////////
// Property "year"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code year} property.
   * @see javax.baja.schedule.BCustomSchedule#getYear
   * @see javax.baja.schedule.BCustomSchedule#setYear
   */
  public static final Property year = newProperty(0, new BYearSchedule().initAlwaysEffective(true),null);

  /**
   * Get the {@code year} property.
   * @see javax.baja.schedule.BCustomSchedule#year
   */
  public BYearSchedule getYear() { return (BYearSchedule)get(year); }

  /**
   * Set the {@code year} property.
   * @see javax.baja.schedule.BCustomSchedule#year
   */
  public void setYear(BYearSchedule v) { set(year,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BCustomSchedule.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /////////////////////////////////////////////////////////////////
  // Constructors
  /////////////////////////////////////////////////////////////////

  public BCustomSchedule() {}


  /////////////////////////////////////////////////////////////////
  // Methods - Public and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////



  @Override
  public String toString(Context cx)
  {
    Lexicon l = Lexicon.make(BAbstractSchedule.class);
    BAbsTime now  = BAbsTime.now();
    BAbsTime time = next(true, BAbsTime.now(), now.nextYear() );


    String info = "";
    if(time != null)
    {
      info=l.getText("custom.nextEvent", new Object[] {time.toDateString(cx)});
    }
    return l.get("type.customSchedule")  + info;
  }

  /////////////////////////////////////////////////////////////////
  // Methods - Protected and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Inner Classes - in alphabetical order by class name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Constants - in alphabetical order by field name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Attributes - in alphabetical order by field name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Initialization
  /////////////////////////////////////////////////////////////////


}//BCustomSchedule
