/*
 * Copyright 2002 Tridium, Inc.  All rights reserved.
 */

package javax.baja.schedule;

import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * @author Aaron Hansen
 * @creation Aug 2002
 * @version $Revision: 13$ $Date: 11/30/05 3:14:17 PM EST$
 */
public class BCalendarSchedule
  extends BControlSchedule
{

  /////////////////////////////////////////////////////////////////
  // Properties
  /////////////////////////////////////////////////////////////////

  public static final Property alwaysEffective = newProperty(Flags.USER_DEFINED_1 | Flags.HIDDEN, false,null);
  public static final Property defaultOutput = newProperty(Flags.HIDDEN | Flags.TRANSIENT, new BStatusBoolean(false), null);
  public static final Property facets = newProperty(Flags.USER_DEFINED_1, BFacets.make(BFacets.TRUE_TEXT,BString.make("true"),BFacets.FALSE_TEXT,BString.make("false")), null);
  public static final Property union = newProperty(Flags.HIDDEN | Flags.READONLY | Flags.USER_DEFINED_1,true,null);

  /*-
  class BCalendarSchedule
  {
    properties
    {
      in : BStatusBoolean
        flags {summary, user_defined_1}
        default {[new BStatusBoolean(false, BStatus.nullStatus)]}
      out : BStatusBoolean
        flags {readonly, summary, transient}
        default {[new BStatusBoolean(false)]}
      nextTime: BAbsTime
        flags {readonly, summary, transient}
        default {[BAbsTime.NULL]}
      nextValue: BStatusBoolean
        flags {readonly, summary, transient}
        default {[new BStatusBoolean(false)]}
    }
    actions
    {
    }
    topics
    {
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.schedule.BCalendarSchedule(789152612)1.0$ @*/
/* Generated Thu Sep 11 10:15:01 EDT 2014 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code in} property.
   * @see #getIn
   * @see #setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY|Flags.USER_DEFINED_1, new BStatusBoolean(false, BStatus.nullStatus),null);

  /**
   * Get the {@code in} property.
   * @see #in
   */
  public BStatusBoolean getIn() { return (BStatusBoolean)get(in); }

  /**
   * Set the {@code in} property.
   * @see #in
   */
  public void setIn(BStatusBoolean v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code out} property.
   * @see #getOut
   * @see #setOut
   */
  public static final Property out = newProperty(Flags.READONLY|Flags.SUMMARY|Flags.TRANSIENT, new BStatusBoolean(false),null);

  /**
   * Get the {@code out} property.
   * @see #out
   */
  public BStatusBoolean getOut() { return (BStatusBoolean)get(out); }

  /**
   * Set the {@code out} property.
   * @see #out
   */
  public void setOut(BStatusBoolean v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "nextTime"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code nextTime} property.
   * @see #getNextTime
   * @see #setNextTime
   */
  public static final Property nextTime = newProperty(Flags.READONLY|Flags.SUMMARY|Flags.TRANSIENT, BAbsTime.NULL,null);

  /**
   * Get the {@code nextTime} property.
   * @see #nextTime
   */
  public BAbsTime getNextTime() { return (BAbsTime)get(nextTime); }

  /**
   * Set the {@code nextTime} property.
   * @see #nextTime
   */
  @Override
  public void setNextTime(BAbsTime v) { set(nextTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "nextValue"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code nextValue} property.
   * @see #getNextValue
   * @see #setNextValue
   */
  public static final Property nextValue = newProperty(Flags.READONLY|Flags.SUMMARY|Flags.TRANSIENT, new BStatusBoolean(false),null);

  /**
   * Get the {@code nextValue} property.
   * @see #nextValue
   */
  public BStatusBoolean getNextValue() { return (BStatusBoolean)get(nextValue); }

  /**
   * Set the {@code nextValue} property.
   * @see #nextValue
   */
  public void setNextValue(BStatusBoolean v) { set(nextValue,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BCalendarSchedule.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /////////////////////////////////////////////////////////////////
  // Constructors
  /////////////////////////////////////////////////////////////////

  public BCalendarSchedule() {}


  /////////////////////////////////////////////////////////////////
  // Methods - Public and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  /**
   * Removes expired events.
   */
  @Override
  public void doCleanup()
  {
    BAbstractSchedule[] ary = getSchedules();
    for (int i = ary.length; --i >= 0; )
    {
      if (isExpired(ary[i]))
      {
        //Issue 21891, grab name before removing event
        String name = ary[i].getName();
        remove(ary[i]);
        log.info(toPathString() + " removing expired event  " + name);
      }
    }
  }

  /**
   * Returns the defaultOutput if there is no scheduled output.
   */
  @Override
  public BStatusValue getOutput(BAbsTime at)
  {
    return new BStatusBoolean(isEffective(at));
  }


  @Override
  public BAbstractSchedule getOutputSource(BAbsTime at)
  {
    BAbstractSchedule[] children = getSchedules();
    int len = children.length;
    for (int i = 0; i < len; i++)
    {
      if (children[i].isEffective(at))
        return children[i];
    }
    return this;
  }

  /////////////////////////////////////////////////////////////////
  // Methods - Protected and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  @Override
  protected BStatusValue getOutput(BAbstractSchedule sch)
  {
    if (sch == this)
      return new BStatusBoolean(false);
    return new BStatusBoolean(true);
  }

  @Override
  protected void setNextVal(BStatusValue v)
  {
    setNextValue((BStatusBoolean)v);
  }

  /////////////////////////////////////////////////////////////////
  // Methods - Private and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Inner Classes - in alphabetical order by class name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Constants - in alphabetical order by field name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Attributes - in alphabetical order by field name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Initialization
  /////////////////////////////////////////////////////////////////


}//BCalendarSchedule
