/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.rdb.ddl;

import javax.baja.sys.*;

/**
 * BOnDelete enumerates the options for 
 * a foreign key's "reference on delete" action
 *
 * @author    Mike Jarmy
 * @creation  20 Jun 07
 * @version   $Revision$Date: 6/22/2007 11:17:32 AM$
 * @since     Baja 1.0
 */
public final class BOnDelete
  extends BFrozenEnum
{
  /*-
  
  enum BOnDelete
  {
    range
    {
      noAction,
      cascade 
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.rdb.ddl.BOnDelete(2798730870)1.0$ @*/
/* Generated Tue Jul 10 12:22:50 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for noAction. */
  public static final int NO_ACTION = 0;
  /** Ordinal value for cascade. */
  public static final int CASCADE = 1;
  
  /** BOnDelete constant for noAction. */
  public static final BOnDelete noAction = new BOnDelete(NO_ACTION);
  /** BOnDelete constant for cascade. */
  public static final BOnDelete cascade = new BOnDelete(CASCADE);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BOnDelete.class);
  
  /** Factory method with ordinal. */
  public static BOnDelete make(int ordinal)
  {
    return (BOnDelete)noAction.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BOnDelete make(String tag)
  {
    return (BOnDelete)noAction.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BOnDelete(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BOnDelete DEFAULT = BOnDelete.noAction;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}

