/*
 * Copyright 2007 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.platform.install;

import javax.baja.sys.*;
import javax.baja.data.*;
import javax.baja.io.BIEncodable;

/**
 * Specifies how a PlatformDependency's version should be checked against
 * a PlatformPart's version
 * 
 * @author    Matt Boon       
 * @creation  3 Apr 07
 * @version   $Revision: 5$ $Date: 9/30/09 12:45:15 PM EDT$
 * @since     Baja 1.0
 */
public final class BVersionRelation
  extends BFrozenEnum
  implements BIEncodable
{
  /*-
    enum BVersionRelation
    {
      range
      {
        minimum,
        exact,
        maximum
      }
    }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.platform.install.BVersionRelation(1464519949)1.0$ @*/
/* Generated Wed Jan 04 14:29:09 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for minimum. */
  public static final int MINIMUM = 0;
  /** Ordinal value for exact. */
  public static final int EXACT = 1;
  /** Ordinal value for maximum. */
  public static final int MAXIMUM = 2;
  
  /** BVersionRelation constant for minimum. */
  public static final BVersionRelation minimum = new BVersionRelation(MINIMUM);
  /** BVersionRelation constant for exact. */
  public static final BVersionRelation exact = new BVersionRelation(EXACT);
  /** BVersionRelation constant for maximum. */
  public static final BVersionRelation maximum = new BVersionRelation(MAXIMUM);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BVersionRelation.class);
  
  /** Factory method with ordinal. */
  public static BVersionRelation make(int ordinal)
  {
    return (BVersionRelation)minimum.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BVersionRelation make(String tag)
  {
    return (BVersionRelation)minimum.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BVersionRelation(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BVersionRelation DEFAULT = BVersionRelation.minimum;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
