/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.platform;

import javax.baja.sys.*;

// IMPORTANT: these values must be kept in sync with platDaemon's
// Station.h header
/**
 * Status codes returned by the Niagara platform daemon
 * 
 * @author    Matt Boon       
 * @creation  03 Jun 02
 * @version   $Revision: 2$ $Date: 5/26/05 1:00:26 PM EDT$
 * @since     Baja 1.0
 */
public final class BStationStatus
  extends BFrozenEnum
{
  /*-
    enum BStationStatus
    {
      range
      {
        idle,      -- station not running
        starting,  -- station started, but hasn't yet reported to niagarad
                   --   that it's at steady-state
        running,   -- station at steady-state
        stopping,  -- stop request sent, but process not yet terminated
        failed,    -- station process ended too quickly, or ended with
                   --   a failure return code
        unknown,   -- status unknown
        halted     -- station stopped, and not restartable without a reboot
      }
    }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.platform.BStationStatus(1372827544)1.0$ @*/
/* Generated Wed Jan 04 14:29:09 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for idle. */
  public static final int IDLE = 0;
  /** Ordinal value for starting. */
  public static final int STARTING = 1;
  /** Ordinal value for running. */
  public static final int RUNNING = 2;
  /** Ordinal value for stopping. */
  public static final int STOPPING = 3;
  /** Ordinal value for failed. */
  public static final int FAILED = 4;
  /** Ordinal value for unknown. */
  public static final int UNKNOWN = 5;
  /** Ordinal value for halted. */
  public static final int HALTED = 6;
  
  /** BStationStatus constant for idle. */
  public static final BStationStatus idle = new BStationStatus(IDLE);
  /** BStationStatus constant for starting. */
  public static final BStationStatus starting = new BStationStatus(STARTING);
  /** BStationStatus constant for running. */
  public static final BStationStatus running = new BStationStatus(RUNNING);
  /** BStationStatus constant for stopping. */
  public static final BStationStatus stopping = new BStationStatus(STOPPING);
  /** BStationStatus constant for failed. */
  public static final BStationStatus failed = new BStationStatus(FAILED);
  /** BStationStatus constant for unknown. */
  public static final BStationStatus unknown = new BStationStatus(UNKNOWN);
  /** BStationStatus constant for halted. */
  public static final BStationStatus halted = new BStationStatus(HALTED);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStationStatus.class);
  
  /** Factory method with ordinal. */
  public static BStationStatus make(int ordinal)
  {
    return (BStationStatus)idle.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BStationStatus make(String tag)
  {
    return (BStationStatus)idle.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BStationStatus(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BStationStatus DEFAULT = BStationStatus.idle;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
