/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.nrio.types;

import javax.baja.driver.point.BProxyExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTriggerRateType extends BAbstractRateType
{
  /*-
  
  class BTriggerRateType
  {
    properties
    {      
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nrio.types.BTriggerRateType(3758255155)1.0$ @*/
/* Generated Mon Jul 30 10:11:47 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BTriggerRateType.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BTriggerRateType()
  {
  }

  public void initType()
  {
    try
    {
      BProxyExt ext = (BProxyExt) getParent();
      
      ext.getParentPoint().add("recalculateRate", new BRecalcRateAction());
    }
    catch(Exception e)
    {
      log.error("Unable to add RecalcRateAction", e);
    }
  }
  
  public void cleanupType()
  {
    try
    {
      BProxyExt ext = (BProxyExt) getParent();
      
      ext.getParentPoint().remove("recalculateRate");
    }
    catch(Exception e)
    {
      log.error("Unable to remove RecalcRateAction", e);
    }
  }
  
  public synchronized void resetRate()
  {
    lastCount = 0;
    lastTicks = 0;
    if (getCounterProxy() != null)
      getCounterProxy().setStale(true, null);
  }
  
  public synchronized BStatusNumeric calculateRate(long count)
  {
    BStatusNumeric srate;
    
    long ticks = Clock.ticks();

    if (lastTicks == 0){
      lastTicks = ticks;
      lastCount = count;      
      return null;
    }

    long tickDelta = ticks - lastTicks;

    float rate = 1000f * (float)(count - lastCount) / (float)tickDelta;        
    rate *= getScale();

    lastTicks = ticks;
    lastCount = count;    
      
    srate = new BStatusNumeric(rate);
    getCounterProxy().setRateCalcTime(BAbsTime.now());

    return srate;
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  private long lastCount = 0;
  private long lastTicks = 0;
}
