/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.nrio.types;

import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.nrio.points.BNrioCounterInputProxyExt;

public class BFixedWindowRateType extends BAbstractRateType
{
  /*-
  
  class BFixedWindowRateType
  {
    properties
    {      
      interval: BRelTime
        default {[ BRelTime.makeSeconds(60) ]}        
        slotfacets {[ BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.FALSE,
                                   BFacets.MIN, BRelTime.make(1000)) ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nrio.types.BFixedWindowRateType(3771200615)1.0$ @*/
/* Generated Mon Jul 30 10:11:47 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "interval"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>interval</code> property.
   * @see com.tridium.nrio.types.BFixedWindowRateType#getInterval
   * @see com.tridium.nrio.types.BFixedWindowRateType#setInterval
   */
  public static final Property interval = newProperty(0, BRelTime.makeSeconds(60),BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.FALSE,
                                   BFacets.MIN, BRelTime.make(1000)) );
  
  /**
   * Get the <code>interval</code> property.
   * @see com.tridium.nrio.types.BFixedWindowRateType#interval
   */
  public BRelTime getInterval() { return (BRelTime)get(interval); }
  
  /**
   * Set the <code>interval</code> property.
   * @see com.tridium.nrio.types.BFixedWindowRateType#interval
   */
  public void setInterval(BRelTime v) { set(interval,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFixedWindowRateType.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BFixedWindowRateType()
  {
  }

  public void descendantsStarted()
    throws Exception
  {
    super.descendantsStarted();
    
    resetRate();
    resetClockTicket();
  }
  
  public void stopped()
    throws Exception
  {
    super.stopped();
    
    resetRate();
    if (ticket != null)
    {
      ticket.cancel();
    }
    ticket = null;
  }

  public void changed(Property property, Context context)
  {
    super.changed(property, context);
    
    if (isRunning())
    {
      if (property.equals(interval))
      {
        resetRate();
        resetClockTicket();
      }  
    }
  }

  public synchronized void resetRate()
  {
    lastCount = 0;
    lastTicks = 0;
    if (getCounterProxy() != null)
      getCounterProxy().setStale(true, null);
  }
  
  public synchronized BStatusNumeric calculateRate(long count)
  {
  	if(ticket == null)
  		resetClockTicket();
  	// return current rate if ticket not expired
  	
  	if(!ticket.isExpired())
  		return new BStatusNumeric(getCounterProxy().getRate());
  	
  	resetClockTicket();
    BStatusNumeric srate;
    
    long ticks = Clock.ticks();

    if (lastTicks == 0){
      lastTicks = ticks;
      lastCount = count;
      
      return null;
    }

    long tickDelta = ticks - lastTicks;

    float rate = 1000f * (float)(count - lastCount) / (float)tickDelta ;
    rate *= getScale();
    lastTicks = ticks;
    lastCount = count;    
      
    srate = new BStatusNumeric(rate);
    getCounterProxy().setRateCalcTime(BAbsTime.now());

    return srate;
  }

  private void resetClockTicket()
  {
    if (ticket != null)
    {
      ticket.cancel();
    }
    ticket = Clock.schedule(getCounterProxy(), getInterval(), 
    		BNrioCounterInputProxyExt.recalculateRate, null); 
  }
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  private long lastCount = 0;
  private long lastTicks = 0;
  private Clock.Ticket ticket = null;
}
