/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.nrio.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * A BFrozenEnum that contains the following types:
 *  unversalInput, analogOutput, booleanOutput
 *
 * @author    Bill Smith
 * @creation  19 Jun 2002
 * @version   $Revision: 1$ $Date: 3/21/2003 1:29:18 PM$
 * @since     Baja 1.0
 */

public final class BNrio16CounterSelectEnum extends BFrozenEnum
{
  public static final int COUNTER_SELECT = 0;
  public static final int RATE_SELECT = 1;
  
  public static final BNrio16CounterSelectEnum count = new BNrio16CounterSelectEnum(COUNTER_SELECT);
  public static final BNrio16CounterSelectEnum rate = new BNrio16CounterSelectEnum(RATE_SELECT);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNrio16CounterSelectEnum.class);
  
  /** Factory method with ordinal. */
  public static BNrio16CounterSelectEnum make(int ordinal)
  {
    return (BNrio16CounterSelectEnum)count.getRange().get(ordinal);
  }
  
  /** Factory method with tag. */
  public static BNrio16CounterSelectEnum make(String tag)
  {
    return (BNrio16CounterSelectEnum)count.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BNrio16CounterSelectEnum(int ordinal)
  {
    super(ordinal);
  }
}
