/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.nrio.components;

import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.nrio.enums.BSdiEnum;

/**
 * BSdiValueConfig - This is a structure to configure SCI AI values for
 * Open, Closed, Cut, Short enumerations.
 *
 * @author    Andy Saunders
 * @creation  Nov 17, 2005
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BSdiValueConfig
  extends BStruct
{
  /*-
  class BSdiValueConfig
  {
    properties
    {
      cutValue : int
        -- This is the unit number of the discovered access device 4096 *5/6
        default{[3412]}
      openValue : int
        -- This is the unit number of the discovered access device 4096 /2
        default{[2047]}
      closedValue : int
        -- This is the unit number of the discovered access device 4096 /2
        default{[682]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nrio.components.BSdiValueConfig(1509293357)1.0$ @*/
/* Generated Wed Jan 11 10:06:37 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "cutValue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>cutValue</code> property.
   * This is the unit number of the discovered access device
   * 4096 *5/6
   * @see com.tridium.nrio.components.BSdiValueConfig#getCutValue
   * @see com.tridium.nrio.components.BSdiValueConfig#setCutValue
   */
  public static final Property cutValue = newProperty(0, 3412,null);
  
  /**
   * Get the <code>cutValue</code> property.
   * @see com.tridium.nrio.components.BSdiValueConfig#cutValue
   */
  public int getCutValue() { return getInt(cutValue); }
  
  /**
   * Set the <code>cutValue</code> property.
   * @see com.tridium.nrio.components.BSdiValueConfig#cutValue
   */
  public void setCutValue(int v) { setInt(cutValue,v,null); }

////////////////////////////////////////////////////////////////
// Property "openValue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>openValue</code> property.
   * This is the unit number of the discovered access device
   * 4096 /2
   * @see com.tridium.nrio.components.BSdiValueConfig#getOpenValue
   * @see com.tridium.nrio.components.BSdiValueConfig#setOpenValue
   */
  public static final Property openValue = newProperty(0, 2047,null);
  
  /**
   * Get the <code>openValue</code> property.
   * @see com.tridium.nrio.components.BSdiValueConfig#openValue
   */
  public int getOpenValue() { return getInt(openValue); }
  
  /**
   * Set the <code>openValue</code> property.
   * @see com.tridium.nrio.components.BSdiValueConfig#openValue
   */
  public void setOpenValue(int v) { setInt(openValue,v,null); }

////////////////////////////////////////////////////////////////
// Property "closedValue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>closedValue</code> property.
   * This is the unit number of the discovered access device
   * 4096 /2
   * @see com.tridium.nrio.components.BSdiValueConfig#getClosedValue
   * @see com.tridium.nrio.components.BSdiValueConfig#setClosedValue
   */
  public static final Property closedValue = newProperty(0, 682,null);
  
  /**
   * Get the <code>closedValue</code> property.
   * @see com.tridium.nrio.components.BSdiValueConfig#closedValue
   */
  public int getClosedValue() { return getInt(closedValue); }
  
  /**
   * Set the <code>closedValue</code> property.
   * @see com.tridium.nrio.components.BSdiValueConfig#closedValue
   */
  public void setClosedValue(int v) { setInt(closedValue,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSdiValueConfig.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BSdiValueConfig(int cut, int open, int closed)
  {
    setCutValue(cut);
    setOpenValue(open);
    setClosedValue(closed);
  }
  public BSdiValueConfig(){}

  public BSdiEnum getEnumValue(int value)
  {
    if(value > getCutValue()) return BSdiEnum.cut;
    if(value > getOpenValue()) return BSdiEnum.open;
    if(value > getClosedValue()) return BSdiEnum.closed;
    return BSdiEnum.shorted;
  }
}