/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.nrio.components;

import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.nrio.enums.BNrioIoTypeEnum;
import com.tridium.nrio.points.BNrioProxyExt;

/**
 * BNrioIOPointEntry - The learn IO Module discovery job places instances of this component.
 * 
 *
 * @author    Andy Saunders
 * @creation  13 Jan 2005
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BNrioIOPointEntry
  extends BComponent
{
  /*-
  class BNrioIOPointEntry
  {
    properties
    {
      ioType : BNrioIoTypeEnum
        -- This is the unit number of the discovered access device
        default{[ BNrioIoTypeEnum.digitalInput]}
      instance : int
        -- This instance number for this IO
        default{[ 0 ]}
      usedByPoint: String
        default{[ "" ]} 
       
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nrio.components.BNrioIOPointEntry(3962140181)1.0$ @*/
/* Generated Sat Aug 04 14:27:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "ioType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>ioType</code> property.
   * This is the unit number of the discovered access device
   * @see com.tridium.nrio.components.BNrioIOPointEntry#getIoType
   * @see com.tridium.nrio.components.BNrioIOPointEntry#setIoType
   */
  public static final Property ioType = newProperty(0, BNrioIoTypeEnum.digitalInput,null);
  
  /**
   * Get the <code>ioType</code> property.
   * @see com.tridium.nrio.components.BNrioIOPointEntry#ioType
   */
  public BNrioIoTypeEnum getIoType() { return (BNrioIoTypeEnum)get(ioType); }
  
  /**
   * Set the <code>ioType</code> property.
   * @see com.tridium.nrio.components.BNrioIOPointEntry#ioType
   */
  public void setIoType(BNrioIoTypeEnum v) { set(ioType,v,null); }

////////////////////////////////////////////////////////////////
// Property "instance"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>instance</code> property.
   * This instance number for this IO
   * @see com.tridium.nrio.components.BNrioIOPointEntry#getInstance
   * @see com.tridium.nrio.components.BNrioIOPointEntry#setInstance
   */
  public static final Property instance = newProperty(0, 0,null);
  
  /**
   * Get the <code>instance</code> property.
   * @see com.tridium.nrio.components.BNrioIOPointEntry#instance
   */
  public int getInstance() { return getInt(instance); }
  
  /**
   * Set the <code>instance</code> property.
   * @see com.tridium.nrio.components.BNrioIOPointEntry#instance
   */
  public void setInstance(int v) { setInt(instance,v,null); }

////////////////////////////////////////////////////////////////
// Property "usedByPoint"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>usedByPoint</code> property.
   * @see com.tridium.nrio.components.BNrioIOPointEntry#getUsedByPoint
   * @see com.tridium.nrio.components.BNrioIOPointEntry#setUsedByPoint
   */
  public static final Property usedByPoint = newProperty(0, "",null);
  
  /**
   * Get the <code>usedByPoint</code> property.
   * @see com.tridium.nrio.components.BNrioIOPointEntry#usedByPoint
   */
  public String getUsedByPoint() { return getString(usedByPoint); }
  
  /**
   * Set the <code>usedByPoint</code> property.
   * @see com.tridium.nrio.components.BNrioIOPointEntry#usedByPoint
   */
  public void setUsedByPoint(String v) { setString(usedByPoint,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNrioIOPointEntry.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BNrioIOPointEntry(BNrioIoTypeEnum type, int instance)
  {
    setIoType(type);
    setInstance(instance);
  }
  public BNrioIOPointEntry(){}

  public boolean matches(BComponent point)
  {
    if(!(point instanceof BControlPoint) )
      return false;
    BControlPoint cp = (BControlPoint)point;
    BAbstractProxyExt proxy = cp.getProxyExt();
    if( !(proxy instanceof BNrioProxyExt) )
      return false;
    if( ((BNrioProxyExt)proxy).isDisabled() )
      return false;
    int proxInstance = ((BNrioProxyExt)proxy).getInstance();
    if( getInstance() != proxInstance)
      return false;

    if( cp instanceof BBooleanWritable )
      return getIoType().equals(BNrioIoTypeEnum.relayOutput) ||
             getIoType().equals(BNrioIoTypeEnum.cardReaderOutput)    ;

    if( cp instanceof BEnumPoint )
      return getIoType().equals(BNrioIoTypeEnum.supervisedDigitalInput);

    if( cp instanceof BBooleanPoint &&  ((BNrioProxyExt)proxy).getIsSdi())
      return getIoType().equals(BNrioIoTypeEnum.supervisedDigitalInput);

    return ( (getIoType().equals(BNrioIoTypeEnum.digitalInput)) && (cp instanceof BBooleanPoint) );  
  }

  public boolean isMatchable(BComponent point)
  {
    if(!(point instanceof BControlPoint) )
      return false;
    BControlPoint cp = (BControlPoint)point;
    BAbstractProxyExt proxy = cp.getProxyExt();
    if( !(proxy instanceof BNrioProxyExt) )
      return false;
    int proxInstance = ((BNrioProxyExt)proxy).getInstance();
    if( proxInstance != 0)
      return false;

    if( cp instanceof BBooleanWritable )
      return getIoType().equals(BNrioIoTypeEnum.relayOutput);

    if( cp instanceof BEnumPoint )
      return getIoType().equals(BNrioIoTypeEnum.supervisedDigitalInput);

    if( cp instanceof BBooleanPoint &&  ((BNrioProxyExt)proxy).getIsSdi())
      return getIoType().equals(BNrioIoTypeEnum.supervisedDigitalInput);

    return ( (getIoType().equals(BNrioIoTypeEnum.digitalInput)) && (cp instanceof BBooleanPoint) );  
  }
}