/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.nrio.components;

import javax.baja.sys.BBlob;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.nrio.messages.NrioInputStream;

/**
 * BNrio16Status - This is a structure to represent the base IO status from an NrioDevice.
 *
 * @author    Andy Saunders
 * @creation  Nov 17, 2005
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BIoStatus
  extends BStruct
{
  /*-
  class BIoStatus
  {
    properties
    {
      ioStatus: BBlob
        -- last io status message received
        flags { transient, readonly }
        default {[ BBlob.DEFAULT ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, BString.make("nrio:FlexBlobFE")) ]}

      sdi1 : int
        -- This is the raw value from the 1st sdi.
        flags{ transient, readonly }
        default{[0]}
      sdi2 : int
        -- This is the raw value from the 1st sdi.
        flags{ transient, readonly }
        default{[0]}
      sdi3 : int
        -- This is the raw value from the 1st sdi.
        flags{ transient, readonly }
        default{[0]}
      sdi4 : int
        -- This is the raw value from the 1st sdi.
        flags{ transient, readonly }
        default{[0]}
      sdi5 : int
        -- This is the raw value from the 1st sdi.
        flags{ transient, readonly }
        default{[0]}
      sdi6 : int
        -- This is the raw value from the 1st sdi.
        flags{ transient, readonly }
        default{[0]}
      sdi7 : int
        -- This is the raw value from the 1st sdi.
        flags{ transient, readonly }
        default{[0]}
      sdi8 : int
        -- This is the raw value from the 1st sdi.
        flags{ transient, readonly }
        default{[0]}
      di1 : boolean
        -- This is the first digital input
        flags{ transient, readonly }
        default{[ false ]}
      di2 : boolean
        -- This is the first digital input
        flags{ transient, readonly }
        default{[ false ]}
      di3 : boolean
        -- This is the first digital input
        flags{ transient, readonly }
        default{[ false ]}


    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nrio.components.BIoStatus(3219247324)1.0$ @*/
/* Generated Thu Feb 14 10:05:08 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "ioStatus"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>ioStatus</code> property.
   * last io status message received
   * @see com.tridium.nrio.components.BIoStatus#getIoStatus
   * @see com.tridium.nrio.components.BIoStatus#setIoStatus
   */
  public static final Property ioStatus = newProperty(Flags.TRANSIENT|Flags.READONLY, BBlob.DEFAULT,BFacets.make(BFacets.FIELD_EDITOR, BString.make("nrio:FlexBlobFE")));
  
  /**
   * Get the <code>ioStatus</code> property.
   * @see com.tridium.nrio.components.BIoStatus#ioStatus
   */
  public BBlob getIoStatus() { return (BBlob)get(ioStatus); }
  
  /**
   * Set the <code>ioStatus</code> property.
   * @see com.tridium.nrio.components.BIoStatus#ioStatus
   */
  public void setIoStatus(BBlob v) { set(ioStatus,v,null); }

////////////////////////////////////////////////////////////////
// Property "sdi1"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>sdi1</code> property.
   * This is the raw value from the 1st sdi.
   * @see com.tridium.nrio.components.BIoStatus#getSdi1
   * @see com.tridium.nrio.components.BIoStatus#setSdi1
   */
  public static final Property sdi1 = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>sdi1</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi1
   */
  public int getSdi1() { return getInt(sdi1); }
  
  /**
   * Set the <code>sdi1</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi1
   */
  public void setSdi1(int v) { setInt(sdi1,v,null); }

////////////////////////////////////////////////////////////////
// Property "sdi2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>sdi2</code> property.
   * This is the raw value from the 1st sdi.
   * @see com.tridium.nrio.components.BIoStatus#getSdi2
   * @see com.tridium.nrio.components.BIoStatus#setSdi2
   */
  public static final Property sdi2 = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>sdi2</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi2
   */
  public int getSdi2() { return getInt(sdi2); }
  
  /**
   * Set the <code>sdi2</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi2
   */
  public void setSdi2(int v) { setInt(sdi2,v,null); }

////////////////////////////////////////////////////////////////
// Property "sdi3"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>sdi3</code> property.
   * This is the raw value from the 1st sdi.
   * @see com.tridium.nrio.components.BIoStatus#getSdi3
   * @see com.tridium.nrio.components.BIoStatus#setSdi3
   */
  public static final Property sdi3 = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>sdi3</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi3
   */
  public int getSdi3() { return getInt(sdi3); }
  
  /**
   * Set the <code>sdi3</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi3
   */
  public void setSdi3(int v) { setInt(sdi3,v,null); }

////////////////////////////////////////////////////////////////
// Property "sdi4"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>sdi4</code> property.
   * This is the raw value from the 1st sdi.
   * @see com.tridium.nrio.components.BIoStatus#getSdi4
   * @see com.tridium.nrio.components.BIoStatus#setSdi4
   */
  public static final Property sdi4 = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>sdi4</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi4
   */
  public int getSdi4() { return getInt(sdi4); }
  
  /**
   * Set the <code>sdi4</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi4
   */
  public void setSdi4(int v) { setInt(sdi4,v,null); }

////////////////////////////////////////////////////////////////
// Property "sdi5"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>sdi5</code> property.
   * This is the raw value from the 1st sdi.
   * @see com.tridium.nrio.components.BIoStatus#getSdi5
   * @see com.tridium.nrio.components.BIoStatus#setSdi5
   */
  public static final Property sdi5 = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>sdi5</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi5
   */
  public int getSdi5() { return getInt(sdi5); }
  
  /**
   * Set the <code>sdi5</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi5
   */
  public void setSdi5(int v) { setInt(sdi5,v,null); }

////////////////////////////////////////////////////////////////
// Property "sdi6"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>sdi6</code> property.
   * This is the raw value from the 1st sdi.
   * @see com.tridium.nrio.components.BIoStatus#getSdi6
   * @see com.tridium.nrio.components.BIoStatus#setSdi6
   */
  public static final Property sdi6 = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>sdi6</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi6
   */
  public int getSdi6() { return getInt(sdi6); }
  
  /**
   * Set the <code>sdi6</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi6
   */
  public void setSdi6(int v) { setInt(sdi6,v,null); }

////////////////////////////////////////////////////////////////
// Property "sdi7"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>sdi7</code> property.
   * This is the raw value from the 1st sdi.
   * @see com.tridium.nrio.components.BIoStatus#getSdi7
   * @see com.tridium.nrio.components.BIoStatus#setSdi7
   */
  public static final Property sdi7 = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>sdi7</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi7
   */
  public int getSdi7() { return getInt(sdi7); }
  
  /**
   * Set the <code>sdi7</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi7
   */
  public void setSdi7(int v) { setInt(sdi7,v,null); }

////////////////////////////////////////////////////////////////
// Property "sdi8"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>sdi8</code> property.
   * This is the raw value from the 1st sdi.
   * @see com.tridium.nrio.components.BIoStatus#getSdi8
   * @see com.tridium.nrio.components.BIoStatus#setSdi8
   */
  public static final Property sdi8 = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>sdi8</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi8
   */
  public int getSdi8() { return getInt(sdi8); }
  
  /**
   * Set the <code>sdi8</code> property.
   * @see com.tridium.nrio.components.BIoStatus#sdi8
   */
  public void setSdi8(int v) { setInt(sdi8,v,null); }

////////////////////////////////////////////////////////////////
// Property "di1"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>di1</code> property.
   * This is the first digital input
   * @see com.tridium.nrio.components.BIoStatus#getDi1
   * @see com.tridium.nrio.components.BIoStatus#setDi1
   */
  public static final Property di1 = newProperty(Flags.TRANSIENT|Flags.READONLY, false,null);
  
  /**
   * Get the <code>di1</code> property.
   * @see com.tridium.nrio.components.BIoStatus#di1
   */
  public boolean getDi1() { return getBoolean(di1); }
  
  /**
   * Set the <code>di1</code> property.
   * @see com.tridium.nrio.components.BIoStatus#di1
   */
  public void setDi1(boolean v) { setBoolean(di1,v,null); }

////////////////////////////////////////////////////////////////
// Property "di2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>di2</code> property.
   * This is the first digital input
   * @see com.tridium.nrio.components.BIoStatus#getDi2
   * @see com.tridium.nrio.components.BIoStatus#setDi2
   */
  public static final Property di2 = newProperty(Flags.TRANSIENT|Flags.READONLY, false,null);
  
  /**
   * Get the <code>di2</code> property.
   * @see com.tridium.nrio.components.BIoStatus#di2
   */
  public boolean getDi2() { return getBoolean(di2); }
  
  /**
   * Set the <code>di2</code> property.
   * @see com.tridium.nrio.components.BIoStatus#di2
   */
  public void setDi2(boolean v) { setBoolean(di2,v,null); }

////////////////////////////////////////////////////////////////
// Property "di3"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>di3</code> property.
   * This is the first digital input
   * @see com.tridium.nrio.components.BIoStatus#getDi3
   * @see com.tridium.nrio.components.BIoStatus#setDi3
   */
  public static final Property di3 = newProperty(Flags.TRANSIENT|Flags.READONLY, false,null);
  
  /**
   * Get the <code>di3</code> property.
   * @see com.tridium.nrio.components.BIoStatus#di3
   */
  public boolean getDi3() { return getBoolean(di3); }
  
  /**
   * Set the <code>di3</code> property.
   * @see com.tridium.nrio.components.BIoStatus#di3
   */
  public void setDi3(boolean v) { setBoolean(di3,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BIoStatus.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BIoStatus()
  {
  }

  public BIoStatus(byte[] data, int start, int length)
  {
    setIoStatus(BBlob.make(data, start, length));

    NrioInputStream in = new NrioInputStream(data, start, length);
    int address = in.read() & 0x0ff;
    int msgLength  = in.read() & 0x0ff;
    int type    = in.read() & 0x0ff;
    int status  = in.read() & 0x0ff;
    setSdi1(in.readSdi());
    setSdi2(in.readSdi());
    setSdi3(in.readSdi());
    setSdi4(in.readSdi());
    setSdi5(in.readSdi());
    setSdi6(in.readSdi());
    setSdi7(in.readSdi());
    setSdi8(in.readSdi());
    int ciData = in.readSdi();
    setDi1( (ciData & 0x0001) == 0 );
    setDi2( (ciData & 0x0002) == 0 );
    setDi3( (ciData & 0x0004) == 0 );
  }

  public byte[] copyBytes()
  {
    return getIoStatus().copyBytes();
  }

}